/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DoNotStrip
public class Arguments {
    private static Object makeNativeObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float || object instanceof Long || object instanceof Byte || object instanceof Short) {
            return ((Number)object).doubleValue();
        }
        if (object.getClass().isArray()) {
            return Arguments.makeNativeArray(object);
        }
        if (object instanceof List) {
            return Arguments.makeNativeArray((List)object);
        }
        if (object instanceof Map) {
            return Arguments.makeNativeMap((Map)object);
        }
        if (object instanceof Bundle) {
            return Arguments.makeNativeMap((Bundle)object);
        }
        if (object instanceof JavaOnlyMap) {
            return Arguments.makeNativeMap(((JavaOnlyMap)object).toHashMap());
        }
        if (object instanceof JavaOnlyArray) {
            return Arguments.makeNativeArray(((JavaOnlyArray)object).toArrayList());
        }
        return object;
    }

    public static WritableNativeArray makeNativeArray(List objects) {
        WritableNativeArray nativeArray = new WritableNativeArray();
        if (objects == null) {
            return nativeArray;
        }
        for (Object elem : objects) {
            if ((elem = Arguments.makeNativeObject(elem)) == null) {
                nativeArray.pushNull();
                continue;
            }
            if (elem instanceof Boolean) {
                nativeArray.pushBoolean((Boolean)elem);
                continue;
            }
            if (elem instanceof Integer) {
                nativeArray.pushInt((Integer)elem);
                continue;
            }
            if (elem instanceof Double) {
                nativeArray.pushDouble((Double)elem);
                continue;
            }
            if (elem instanceof String) {
                nativeArray.pushString((String)elem);
                continue;
            }
            if (elem instanceof WritableNativeArray) {
                nativeArray.pushArray((WritableNativeArray)elem);
                continue;
            }
            if (elem instanceof WritableNativeMap) {
                nativeArray.pushMap((WritableNativeMap)elem);
                continue;
            }
            throw new IllegalArgumentException("Could not convert " + elem.getClass());
        }
        return nativeArray;
    }

    public static <T> WritableNativeArray makeNativeArray(final Object objects) {
        if (objects == null) {
            return new WritableNativeArray();
        }
        return Arguments.makeNativeArray(new AbstractList(){

            @Override
            public int size() {
                return Array.getLength(objects);
            }

            @Override
            public Object get(int index) {
                return Array.get(objects, index);
            }
        });
    }

    private static void addEntry(WritableNativeMap nativeMap, String key, Object value) {
        if ((value = Arguments.makeNativeObject(value)) == null) {
            nativeMap.putNull(key);
        } else if (value instanceof Boolean) {
            nativeMap.putBoolean(key, (Boolean)value);
        } else if (value instanceof Integer) {
            nativeMap.putInt(key, (Integer)value);
        } else if (value instanceof Number) {
            nativeMap.putDouble(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            nativeMap.putString(key, (String)value);
        } else if (value instanceof WritableNativeArray) {
            nativeMap.putArray(key, (WritableNativeArray)value);
        } else if (value instanceof WritableNativeMap) {
            nativeMap.putMap(key, (WritableNativeMap)value);
        } else {
            throw new IllegalArgumentException("Could not convert " + value.getClass());
        }
    }

    @DoNotStrip
    public static WritableNativeMap makeNativeMap(Map<String, Object> objects) {
        WritableNativeMap nativeMap = new WritableNativeMap();
        if (objects == null) {
            return nativeMap;
        }
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            Arguments.addEntry(nativeMap, entry.getKey(), entry.getValue());
        }
        return nativeMap;
    }

    @DoNotStrip
    public static WritableNativeMap makeNativeMap(Bundle bundle) {
        WritableNativeMap nativeMap = new WritableNativeMap();
        if (bundle == null) {
            return nativeMap;
        }
        for (String key : bundle.keySet()) {
            Arguments.addEntry(nativeMap, key, bundle.get(key));
        }
        return nativeMap;
    }

    public static WritableArray createArray() {
        return new WritableNativeArray();
    }

    public static WritableMap createMap() {
        return new WritableNativeMap();
    }

    public static WritableNativeArray fromJavaArgs(Object[] args) {
        WritableNativeArray arguments = new WritableNativeArray();
        for (int i = 0; i < args.length; ++i) {
            Object argument = args[i];
            if (argument == null) {
                arguments.pushNull();
                continue;
            }
            Class<?> argumentClass = argument.getClass();
            if (argumentClass == Boolean.class) {
                arguments.pushBoolean((Boolean)argument);
                continue;
            }
            if (argumentClass == Integer.class) {
                arguments.pushDouble(((Integer)argument).doubleValue());
                continue;
            }
            if (argumentClass == Double.class) {
                arguments.pushDouble((Double)argument);
                continue;
            }
            if (argumentClass == Float.class) {
                arguments.pushDouble(((Float)argument).doubleValue());
                continue;
            }
            if (argumentClass == String.class) {
                arguments.pushString(argument.toString());
                continue;
            }
            if (argumentClass == WritableNativeMap.class) {
                arguments.pushMap((WritableNativeMap)argument);
                continue;
            }
            if (argumentClass == WritableNativeArray.class) {
                arguments.pushArray((WritableNativeArray)argument);
                continue;
            }
            throw new RuntimeException("Cannot convert argument of type " + argumentClass);
        }
        return arguments;
    }

    public static WritableArray fromArray(Object array) {
        WritableArray catalystArray = Arguments.createArray();
        if (array instanceof String[]) {
            for (String v : (String[])array) {
                catalystArray.pushString(v);
            }
        } else if (array instanceof Bundle[]) {
            for (Bundle v : (Bundle[])array) {
                catalystArray.pushMap(Arguments.fromBundle(v));
            }
        } else if (array instanceof int[]) {
            for (int v : (int[])array) {
                catalystArray.pushInt(v);
            }
        } else if (array instanceof float[]) {
            for (float v : (float[])array) {
                catalystArray.pushDouble(v);
            }
        } else if (array instanceof double[]) {
            for (double v : (double[])array) {
                catalystArray.pushDouble(v);
            }
        } else if (array instanceof boolean[]) {
            for (boolean v : (boolean[])array) {
                catalystArray.pushBoolean(v);
            }
        } else if (array instanceof Parcelable[]) {
            for (Parcelable v : (Parcelable[])array) {
                if (!(v instanceof Bundle)) {
                    throw new IllegalArgumentException("Unexpected array member type " + v.getClass());
                }
                catalystArray.pushMap(Arguments.fromBundle((Bundle)v));
            }
        } else {
            throw new IllegalArgumentException("Unknown array type " + array.getClass());
        }
        return catalystArray;
    }

    public static WritableArray fromList(List list) {
        WritableArray catalystArray = Arguments.createArray();
        for (Object obj : list) {
            if (obj == null) {
                catalystArray.pushNull();
                continue;
            }
            if (obj.getClass().isArray()) {
                catalystArray.pushArray(Arguments.fromArray(obj));
                continue;
            }
            if (obj instanceof Bundle) {
                catalystArray.pushMap(Arguments.fromBundle((Bundle)obj));
                continue;
            }
            if (obj instanceof List) {
                catalystArray.pushArray(Arguments.fromList((List)obj));
                continue;
            }
            if (obj instanceof String) {
                catalystArray.pushString((String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                catalystArray.pushInt((Integer)obj);
                continue;
            }
            if (obj instanceof Number) {
                catalystArray.pushDouble(((Number)obj).doubleValue());
                continue;
            }
            if (obj instanceof Boolean) {
                catalystArray.pushBoolean((Boolean)obj);
                continue;
            }
            throw new IllegalArgumentException("Unknown value type " + obj.getClass());
        }
        return catalystArray;
    }

    public static WritableMap fromBundle(Bundle bundle) {
        WritableMap map = Arguments.createMap();
        for (String key : bundle.keySet()) {
            Object value = bundle.get(key);
            if (value == null) {
                map.putNull(key);
                continue;
            }
            if (value.getClass().isArray()) {
                map.putArray(key, Arguments.fromArray(value));
                continue;
            }
            if (value instanceof String) {
                map.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    map.putInt(key, (Integer)value);
                    continue;
                }
                map.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                map.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Bundle) {
                map.putMap(key, Arguments.fromBundle((Bundle)value));
                continue;
            }
            if (value instanceof List) {
                map.putArray(key, Arguments.fromList((List)value));
                continue;
            }
            throw new IllegalArgumentException("Could not convert " + value.getClass());
        }
        return map;
    }

    @Nullable
    public static ArrayList toList(@Nullable ReadableArray readableArray) {
        if (readableArray == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        block8: for (int i = 0; i < readableArray.size(); ++i) {
            switch (readableArray.getType(i)) {
                case Null: {
                    list.add(null);
                    continue block8;
                }
                case Boolean: {
                    list.add(readableArray.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    double number = readableArray.getDouble(i);
                    if (number == Math.rint(number)) {
                        list.add((int)number);
                        continue block8;
                    }
                    list.add(number);
                    continue block8;
                }
                case String: {
                    list.add(readableArray.getString(i));
                    continue block8;
                }
                case Map: {
                    list.add(Arguments.toBundle(readableArray.getMap(i)));
                    continue block8;
                }
                case Array: {
                    list.add(Arguments.toList(readableArray.getArray(i)));
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert object in array.");
                }
            }
        }
        return list;
    }

    @Nullable
    public static Bundle toBundle(@Nullable ReadableMap readableMap) {
        if (readableMap == null) {
            return null;
        }
        ReadableMapKeySetIterator iterator2 = readableMap.keySetIterator();
        Bundle bundle = new Bundle();
        block8: while (iterator2.hasNextKey()) {
            String key = iterator2.nextKey();
            ReadableType readableType = readableMap.getType(key);
            switch (readableType) {
                case Null: {
                    bundle.putString(key, null);
                    continue block8;
                }
                case Boolean: {
                    bundle.putBoolean(key, readableMap.getBoolean(key));
                    continue block8;
                }
                case Number: {
                    bundle.putDouble(key, readableMap.getDouble(key));
                    continue block8;
                }
                case String: {
                    bundle.putString(key, readableMap.getString(key));
                    continue block8;
                }
                case Map: {
                    bundle.putBundle(key, Arguments.toBundle(readableMap.getMap(key)));
                    continue block8;
                }
                case Array: {
                    bundle.putSerializable(key, (Serializable)Arguments.toList(readableMap.getArray(key)));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Could not convert object with key: " + key + ".");
        }
        return bundle;
    }
}

