/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import java.util.Locale;

public class DefaultDevLoadingViewImplementation
implements DevLoadingViewManager {
    private static boolean sEnabled = true;
    private final ReactInstanceDevHelper mReactInstanceDevHelper;
    @Nullable
    private TextView mDevLoadingView;
    @Nullable
    private PopupWindow mDevLoadingPopup;

    public static void setDevLoadingEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public DefaultDevLoadingViewImplementation(ReactInstanceDevHelper reactInstanceManagerHelper) {
        this.mReactInstanceDevHelper = reactInstanceManagerHelper;
    }

    @Override
    public void showMessage(final String message) {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultDevLoadingViewImplementation.this.showInternal(message);
            }
        });
    }

    @Override
    public void updateProgress(final @Nullable String status, final @Nullable Integer done, final @Nullable Integer total) {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                StringBuilder message = new StringBuilder();
                message.append(status != null ? status : "Loading");
                if (done != null && total != null && total > 0) {
                    message.append(String.format(Locale.getDefault(), " %.1f%%", Float.valueOf((float)done.intValue() / (float)total.intValue() * 100.0f)));
                }
                message.append("\u2026");
                if (DefaultDevLoadingViewImplementation.this.mDevLoadingView != null) {
                    DefaultDevLoadingViewImplementation.this.mDevLoadingView.setText((CharSequence)message);
                }
            }
        });
    }

    @Override
    public void hide() {
        if (!sEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                DefaultDevLoadingViewImplementation.this.hideInternal();
            }
        });
    }

    private void showInternal(String message) {
        if (this.mDevLoadingPopup != null && this.mDevLoadingPopup.isShowing()) {
            return;
        }
        Activity currentActivity = this.mReactInstanceDevHelper.getCurrentActivity();
        if (currentActivity == null) {
            FLog.e((String)"ReactNative", (String)"Unable to display loading message because react activity isn't available");
            return;
        }
        try {
            Rect rectangle = new Rect();
            currentActivity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rectangle);
            int topOffset = rectangle.top;
            LayoutInflater inflater = (LayoutInflater)currentActivity.getSystemService("layout_inflater");
            this.mDevLoadingView = (TextView)inflater.inflate(R.layout.dev_loading_view, null);
            this.mDevLoadingView.setText((CharSequence)message);
            this.mDevLoadingPopup = new PopupWindow((View)this.mDevLoadingView, -1, -2);
            this.mDevLoadingPopup.setTouchable(false);
            this.mDevLoadingPopup.showAtLocation(currentActivity.getWindow().getDecorView(), 0, 0, topOffset);
        }
        catch (WindowManager.BadTokenException e) {
            FLog.e((String)"ReactNative", (String)("Unable to display loading message because react activity isn't active, message: " + message));
        }
    }

    private void hideInternal() {
        if (this.mDevLoadingPopup != null && this.mDevLoadingPopup.isShowing()) {
            this.mDevLoadingPopup.dismiss();
            this.mDevLoadingPopup = null;
            this.mDevLoadingView = null;
        }
    }

    @Nullable
    private Context getContext() {
        return this.mReactInstanceDevHelper.getCurrentActivity();
    }
}

