/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.fabric.BindingImpl;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.ReactNativeConfig;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.systrace.Systrace;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class FabricUIManagerProviderImpl
implements UIManagerProvider {
    private final ComponentFactory mComponentFactory;
    private final ReactNativeConfig mConfig;
    private final ViewManagerRegistry mViewManagerRegistry;

    public FabricUIManagerProviderImpl(ComponentFactory componentFactory, ReactNativeConfig config, ViewManagerRegistry viewManagerRegistry2) {
        this.mComponentFactory = componentFactory;
        this.mConfig = config;
        this.mViewManagerRegistry = viewManagerRegistry2;
    }

    @Override
    public UIManager createUIManager(ReactApplicationContext reactApplicationContext) {
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.create");
        EventBeatManager eventBeatManager = new EventBeatManager();
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.createUIManager");
        FabricUIManager fabricUIManager = new FabricUIManager(reactApplicationContext, this.mViewManagerRegistry, eventBeatManager);
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.registerBinding");
        BindingImpl binding = new BindingImpl();
        CatalystInstance catalystInstance = reactApplicationContext.getCatalystInstance();
        binding.register(catalystInstance.getRuntimeExecutor(), catalystInstance.getRuntimeScheduler(), fabricUIManager, eventBeatManager, this.mComponentFactory, this.mConfig);
        Systrace.endSection(0L);
        Systrace.endSection(0L);
        return fabricUIManager;
    }
}

