/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.events.EventEmitterWrapper;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.FabricNameComponentMapping;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.uimanager.StateWrapper;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
final class PreAllocateViewMountItem
implements MountItem {
    @NonNull
    private final String mComponent;
    private final int mSurfaceId;
    private final int mReactTag;
    @Nullable
    private final ReadableMap mProps;
    @Nullable
    private final StateWrapper mStateWrapper;
    @Nullable
    private final EventEmitterWrapper mEventEmitterWrapper;
    private final boolean mIsLayoutable;

    PreAllocateViewMountItem(int surfaceId, int reactTag, @NonNull String component, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, @Nullable EventEmitterWrapper eventEmitterWrapper, boolean isLayoutable) {
        this.mComponent = FabricNameComponentMapping.getFabricComponentName(component);
        this.mSurfaceId = surfaceId;
        this.mProps = props;
        this.mStateWrapper = stateWrapper;
        this.mEventEmitterWrapper = eventEmitterWrapper;
        this.mReactTag = reactTag;
        this.mIsLayoutable = isLayoutable;
    }

    @Override
    public int getSurfaceId() {
        return this.mSurfaceId;
    }

    @Override
    public void execute(@NonNull MountingManager mountingManager) {
        SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(this.mSurfaceId);
        if (surfaceMountingManager == null) {
            FLog.e((String)FabricUIManager.TAG, (String)("Skipping View PreAllocation; no SurfaceMountingManager found for [" + this.mSurfaceId + "]"));
            return;
        }
        surfaceMountingManager.preallocateView(this.mComponent, this.mReactTag, this.mProps, this.mStateWrapper, this.mEventEmitterWrapper, this.mIsLayoutable);
    }

    @NonNull
    public String toString() {
        StringBuilder result = new StringBuilder("PreAllocateViewMountItem [").append(this.mReactTag).append("] - component: ").append(this.mComponent).append(" surfaceId: ").append(this.mSurfaceId).append(" isLayoutable: ").append(this.mIsLayoutable);
        return result.toString();
    }
}

