/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.runtime.internal.bolts.BoltsExecutors;
import com.facebook.react.runtime.internal.bolts.CancellationToken;
import com.facebook.react.runtime.internal.bolts.CancellationTokenRegistration;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class CancellationTokenSource
implements Closeable {
    private final Object lock = new Object();
    @NonNull
    private final List<CancellationTokenRegistration> registrations = new ArrayList<CancellationTokenRegistration>();
    @NonNull
    private final ScheduledExecutorService executor = BoltsExecutors.scheduled();
    @Nullable
    private ScheduledFuture<?> scheduledCancellation;
    private boolean cancellationRequested;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancellationRequested() {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            return this.cancellationRequested;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public CancellationToken getToken() {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            return new CancellationToken(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayList<CancellationTokenRegistration> registrations;
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            if (this.cancellationRequested) {
                return;
            }
            this.cancelScheduledCancellation();
            this.cancellationRequested = true;
            registrations = new ArrayList<CancellationTokenRegistration>(this.registrations);
        }
        this.notifyListeners(registrations);
    }

    public void cancelAfter(long delay) {
        this.cancelAfter(delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAfter(long delay, @NonNull TimeUnit timeUnit) {
        if (delay < -1L) {
            throw new IllegalArgumentException("Delay must be >= -1");
        }
        if (delay == 0L) {
            this.cancel();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.cancellationRequested) {
                return;
            }
            this.cancelScheduledCancellation();
            if (delay != -1L) {
                this.scheduledCancellation = this.executor.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = CancellationTokenSource.this.lock;
                        synchronized (object) {
                            CancellationTokenSource.this.scheduledCancellation = null;
                        }
                        CancellationTokenSource.this.cancel();
                    }
                }, delay, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.cancelScheduledCancellation();
            ArrayList<CancellationTokenRegistration> registrations = new ArrayList<CancellationTokenRegistration>(this.registrations);
            for (CancellationTokenRegistration registration : registrations) {
                registration.close();
            }
            this.registrations.clear();
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    CancellationTokenRegistration register(@NonNull Runnable action) {
        CancellationTokenRegistration ctr;
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            ctr = new CancellationTokenRegistration(this, action);
            if (this.cancellationRequested) {
                ctr.runAction();
            } else {
                this.registrations.add(ctr);
            }
        }
        return ctr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void throwIfCancellationRequested() throws CancellationException {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            if (this.cancellationRequested) {
                throw new CancellationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(@NonNull CancellationTokenRegistration registration) {
        Object object = this.lock;
        synchronized (object) {
            this.throwIfClosed();
            this.registrations.remove(registration);
        }
    }

    private void notifyListeners(@NonNull List<CancellationTokenRegistration> registrations) {
        for (CancellationTokenRegistration registration : registrations) {
            registration.runAction();
        }
    }

    public String toString() {
        return String.format(Locale.US, "%s@%s[cancellationRequested=%s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), Boolean.toString(this.isCancellationRequested()));
    }

    private void throwIfClosed() {
        if (this.closed) {
            throw new IllegalStateException("Object already closed");
        }
    }

    private void cancelScheduledCancellation() {
        if (this.scheduledCancellation != null) {
            this.scheduledCancellation.cancel(true);
            this.scheduledCancellation = null;
        }
    }
}

