/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.views.text.BasicTextAttributeProvider;
import com.facebook.react.views.text.EffectiveTextAttributeProvider;
import com.facebook.react.views.text.ReactBaseTextShadowNode;
import com.facebook.react.views.text.TextAttributes;
import com.facebook.react.views.text.TextTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u0004\u0018\u00010\u001cX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0012\u0010!\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0012\u0010#\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u0012\u0010%\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010'R\u0012\u0010(\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010'R\u0012\u0010)\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0012\u0010*\u001a\u00020&X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010'R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u0004\u0018\u00010,X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010/\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00101\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0018R\u0012\u00103\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0018R\u0012\u00105\u001a\u00020\u0016X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0018R\u0014\u00107\u001a\u0002088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:\u00a8\u0006;"}, d2={"Lcom/facebook/react/views/text/HierarchicTextAttributeProvider;", "Lcom/facebook/react/views/text/EffectiveTextAttributeProvider;", "Lcom/facebook/react/views/text/BasicTextAttributeProvider;", "textShadowNode", "Lcom/facebook/react/views/text/ReactBaseTextShadowNode;", "parentTextAttributes", "Lcom/facebook/react/views/text/TextAttributes;", "textAttributes", "(Lcom/facebook/react/views/text/ReactBaseTextShadowNode;Lcom/facebook/react/views/text/TextAttributes;Lcom/facebook/react/views/text/TextAttributes;)V", "accessibilityRole", "Lcom/facebook/react/uimanager/ReactAccessibilityDelegate$AccessibilityRole;", "getAccessibilityRole", "()Lcom/facebook/react/uimanager/ReactAccessibilityDelegate$AccessibilityRole;", "backgroundColor", "", "getBackgroundColor", "()I", "color", "getColor", "effectiveFontSize", "getEffectiveFontSize", "effectiveLetterSpacing", "", "getEffectiveLetterSpacing", "()F", "effectiveLineHeight", "getEffectiveLineHeight", "fontFamily", "", "getFontFamily", "()Ljava/lang/String;", "fontFeatureSettings", "getFontFeatureSettings", "fontStyle", "getFontStyle", "fontWeight", "getFontWeight", "isBackgroundColorSet", "", "()Z", "isColorSet", "isLineThroughTextDecorationSet", "isUnderlineTextDecorationSet", "role", "Lcom/facebook/react/uimanager/ReactAccessibilityDelegate$Role;", "getRole", "()Lcom/facebook/react/uimanager/ReactAccessibilityDelegate$Role;", "textShadowColor", "getTextShadowColor", "textShadowOffsetDx", "getTextShadowOffsetDx", "textShadowOffsetDy", "getTextShadowOffsetDy", "textShadowRadius", "getTextShadowRadius", "textTransform", "Lcom/facebook/react/views/text/TextTransform;", "getTextTransform", "()Lcom/facebook/react/views/text/TextTransform;", "ReactAndroid_release"})
public final class HierarchicTextAttributeProvider
implements EffectiveTextAttributeProvider,
BasicTextAttributeProvider {
    @NotNull
    private final ReactBaseTextShadowNode textShadowNode;
    @Nullable
    private final TextAttributes parentTextAttributes;
    @NotNull
    private final TextAttributes textAttributes;

    public HierarchicTextAttributeProvider(@NotNull ReactBaseTextShadowNode textShadowNode, @Nullable TextAttributes parentTextAttributes, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkNotNullParameter((Object)textShadowNode, (String)"textShadowNode");
        Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
        this.textShadowNode = textShadowNode;
        this.parentTextAttributes = parentTextAttributes;
        this.textAttributes = textAttributes;
    }

    @Override
    @Nullable
    public ReactAccessibilityDelegate.AccessibilityRole getAccessibilityRole() {
        return this.textShadowNode.getAccessibilityRole();
    }

    @Override
    public int getBackgroundColor() {
        return this.textShadowNode.getBackgroundColor();
    }

    @Override
    public int getColor() {
        return this.textShadowNode.getColor();
    }

    @Override
    @Nullable
    public String getFontFamily() {
        return this.textShadowNode.getFontFamily();
    }

    @Override
    @Nullable
    public String getFontFeatureSettings() {
        return this.textShadowNode.getFontFeatureSettings();
    }

    @Override
    public int getFontStyle() {
        return this.textShadowNode.getFontStyle();
    }

    @Override
    public int getFontWeight() {
        return this.textShadowNode.getFontWeight();
    }

    @Override
    public boolean isBackgroundColorSet() {
        return this.textShadowNode.isBackgroundColorSet();
    }

    @Override
    public boolean isColorSet() {
        return this.textShadowNode.isColorSet();
    }

    @Override
    public boolean isLineThroughTextDecorationSet() {
        return this.textShadowNode.isLineThroughTextDecorationSet();
    }

    @Override
    public boolean isUnderlineTextDecorationSet() {
        return this.textShadowNode.isUnderlineTextDecorationSet();
    }

    @Override
    @Nullable
    public ReactAccessibilityDelegate.Role getRole() {
        return this.textShadowNode.getRole();
    }

    @Override
    public int getTextShadowColor() {
        return this.textShadowNode.getTextShadowColor();
    }

    @Override
    public float getTextShadowOffsetDx() {
        return this.textShadowNode.getTextShadowOffsetDx();
    }

    @Override
    public float getTextShadowOffsetDy() {
        return this.textShadowNode.getTextShadowOffsetDy();
    }

    @Override
    public float getTextShadowRadius() {
        return this.textShadowNode.getTextShadowRadius();
    }

    @Override
    @NotNull
    public TextTransform getTextTransform() {
        TextTransform textTransform = this.textAttributes.getTextTransform();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)textTransform), (String)"getTextTransform(...)");
        return textTransform;
    }

    @Override
    public float getEffectiveLetterSpacing() {
        float letterSpacing = this.textAttributes.getEffectiveLetterSpacing();
        boolean isParentLetterSpacingDifferent = this.parentTextAttributes == null || !(this.parentTextAttributes.getEffectiveLetterSpacing() == letterSpacing);
        return !Float.isNaN(letterSpacing) && isParentLetterSpacingDifferent ? letterSpacing : Float.NaN;
    }

    @Override
    public int getEffectiveFontSize() {
        int fontSize = this.textAttributes.getEffectiveFontSize();
        return this.parentTextAttributes == null || this.parentTextAttributes.getEffectiveFontSize() != fontSize ? fontSize : -1;
    }

    @Override
    public float getEffectiveLineHeight() {
        float lineHeight = this.textAttributes.getEffectiveLineHeight();
        boolean isParentLineHeightDifferent = this.parentTextAttributes == null || !(this.parentTextAttributes.getEffectiveLineHeight() == lineHeight);
        return !Float.isNaN(lineHeight) && isParentLineHeightDifferent ? lineHeight : Float.NaN;
    }
}

