/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.internal.span;

import android.content.Context;
import android.text.TextPaint;
import android.text.style.ClickableSpan;
import android.view.View;
import androidx.annotation.NonNull;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.text.internal.span.ReactSpan;
import com.facebook.react.views.view.ViewGroupClickEvent;

public class ReactClickableSpan
extends ClickableSpan
implements ReactSpan {
    private final int mReactTag;

    public ReactClickableSpan(int reactTag) {
        this.mReactTag = reactTag;
    }

    public void onClick(@NonNull View view) {
        ReactContext context = (ReactContext)view.getContext();
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(context, this.mReactTag);
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent(new ViewGroupClickEvent(UIManagerHelper.getSurfaceId((Context)context), this.mReactTag));
        }
    }

    public void updateDrawState(@NonNull TextPaint ds) {
    }

    public int getReactTag() {
        return this.mReactTag;
    }
}

