/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.react.BaseReactPackage;
import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.CxxModuleWrapper;
import com.facebook.react.bridge.ModuleSpec;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.internal.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.module.model.ReactModuleInfo;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;

public abstract class ReactPackageTurboModuleManagerDelegate
extends TurboModuleManagerDelegate {
    private final List<ModuleProvider> mModuleProviders = new ArrayList<ModuleProvider>();
    private final Map<ModuleProvider, Map<String, ReactModuleInfo>> mPackageModuleInfos = new HashMap<ModuleProvider, Map<String, ReactModuleInfo>>();
    private final boolean mShouldEnableLegacyModuleInterop = ReactFeatureFlags.enableBridgelessArchitecture && ReactNativeFeatureFlags.useTurboModuleInterop();
    private List<ReactPackage> mPackages;
    private ReactApplicationContext mReactContext;

    protected ReactPackageTurboModuleManagerDelegate(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages) {
        this.initialize(reactApplicationContext, packages);
    }

    protected ReactPackageTurboModuleManagerDelegate(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages, HybridData hybridData) {
        super(hybridData);
        this.initialize(reactApplicationContext, packages);
    }

    private void initialize(ReactApplicationContext reactApplicationContext, List<ReactPackage> packages) {
        ReactApplicationContext applicationContext = reactApplicationContext;
        for (ReactPackage reactPackage : packages) {
            Object moduleProvider;
            if (reactPackage instanceof BaseReactPackage) {
                BaseReactPackage baseReactPackage = (BaseReactPackage)reactPackage;
                ModuleProvider moduleProvider2 = moduleName -> baseReactPackage.getModule(moduleName, applicationContext);
                this.mModuleProviders.add(moduleProvider2);
                this.mPackageModuleInfos.put(moduleProvider2, baseReactPackage.getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (this.shouldSupportLegacyPackages() && reactPackage instanceof LazyReactPackage) {
                LazyReactPackage lazyPkg = (LazyReactPackage)reactPackage;
                List<ModuleSpec> moduleSpecs = lazyPkg.getNativeModules(reactApplicationContext);
                HashMap<String, Provider<? extends NativeModule>> moduleSpecProviderMap = new HashMap<String, Provider<? extends NativeModule>>();
                for (ModuleSpec moduleSpec : moduleSpecs) {
                    moduleSpecProviderMap.put(moduleSpec.getName(), moduleSpec.getProvider());
                }
                moduleProvider = moduleName -> {
                    Provider provider = (Provider)moduleSpecProviderMap.get(moduleName);
                    return provider != null ? (NativeModule)provider.get() : null;
                };
                this.mModuleProviders.add((ModuleProvider)moduleProvider);
                this.mPackageModuleInfos.put((ModuleProvider)moduleProvider, lazyPkg.getReactModuleInfoProvider().getReactModuleInfos());
                continue;
            }
            if (!this.shouldSupportLegacyPackages()) continue;
            List<NativeModule> nativeModules = reactPackage.createNativeModules(reactApplicationContext);
            HashMap<String, NativeModule> moduleMap = new HashMap<String, NativeModule>();
            HashMap<String, ReactModuleInfo> reactModuleInfoMap = new HashMap<String, ReactModuleInfo>();
            for (NativeModule module : nativeModules) {
                Class<?> moduleClass = module.getClass();
                ReactModule reactModule = moduleClass.getAnnotation(ReactModule.class);
                String moduleName2 = reactModule != null ? reactModule.name() : module.getName();
                ReactModuleInfo moduleInfo = reactModule != null ? new ReactModuleInfo(moduleName2, moduleClass.getName(), reactModule.canOverrideExistingModule(), true, reactModule.isCxxModule(), ReactModuleInfo.classIsTurboModule(moduleClass)) : new ReactModuleInfo(moduleName2, moduleClass.getName(), module.canOverrideExistingModule(), true, CxxModuleWrapper.class.isAssignableFrom(moduleClass), ReactModuleInfo.classIsTurboModule(moduleClass));
                reactModuleInfoMap.put(moduleName2, moduleInfo);
                moduleMap.put(moduleName2, module);
            }
            moduleProvider = moduleMap::get;
            this.mModuleProviders.add((ModuleProvider)moduleProvider);
            this.mPackageModuleInfos.put((ModuleProvider)moduleProvider, reactModuleInfoMap);
        }
    }

    @Override
    public boolean unstable_shouldEnableLegacyModuleInterop() {
        return this.mShouldEnableLegacyModuleInterop;
    }

    @Override
    @Nullable
    public TurboModule getModule(String moduleName) {
        boolean isLegacyModule;
        NativeModule resolvedModule = null;
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            NativeModule module;
            ReactModuleInfo moduleInfo = this.mPackageModuleInfos.get(moduleProvider).get(moduleName);
            if (moduleInfo == null || !moduleInfo.isTurboModule() || resolvedModule != null && !moduleInfo.canOverrideExistingModule() || (module = moduleProvider.getModule(moduleName)) == null) continue;
            resolvedModule = module;
        }
        boolean bl = isLegacyModule = !(resolvedModule instanceof TurboModule);
        if (isLegacyModule) {
            return null;
        }
        return (TurboModule)((Object)resolvedModule);
    }

    @Override
    public boolean unstable_isModuleRegistered(String moduleName) {
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            ReactModuleInfo moduleInfo = this.mPackageModuleInfos.get(moduleProvider).get(moduleName);
            if (moduleInfo == null || !moduleInfo.isTurboModule()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unstable_isLegacyModuleRegistered(String moduleName) {
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            ReactModuleInfo moduleInfo = this.mPackageModuleInfos.get(moduleProvider).get(moduleName);
            if (moduleInfo == null || moduleInfo.isTurboModule()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public NativeModule getLegacyModule(String moduleName) {
        boolean isLegacyModule;
        if (!this.unstable_shouldEnableLegacyModuleInterop()) {
            return null;
        }
        NativeModule resolvedModule = null;
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            NativeModule module;
            ReactModuleInfo moduleInfo = this.mPackageModuleInfos.get(moduleProvider).get(moduleName);
            if (moduleInfo == null || moduleInfo.isTurboModule() || resolvedModule != null && !moduleInfo.canOverrideExistingModule() || (module = moduleProvider.getModule(moduleName)) == null) continue;
            resolvedModule = module;
        }
        boolean bl = isLegacyModule = !(resolvedModule instanceof TurboModule);
        if (!isLegacyModule) {
            return null;
        }
        return resolvedModule;
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (ModuleProvider moduleProvider : this.mModuleProviders) {
            for (ReactModuleInfo moduleInfo : this.mPackageModuleInfos.get(moduleProvider).values()) {
                if (!moduleInfo.isTurboModule() || !moduleInfo.needsEagerInit()) continue;
                moduleNames.add(moduleInfo.name());
            }
        }
        return moduleNames;
    }

    private boolean shouldSupportLegacyPackages() {
        return this.unstable_shouldEnableLegacyModuleInterop();
    }

    static interface ModuleProvider {
        @Nullable
        public NativeModule getModule(String var1);
    }

    public static abstract class Builder {
        @Nullable
        private List<ReactPackage> mPackages;
        @Nullable
        private ReactApplicationContext mContext;

        public Builder setPackages(List<ReactPackage> packages) {
            this.mPackages = new ArrayList<ReactPackage>(packages);
            return this;
        }

        public Builder setReactApplicationContext(ReactApplicationContext context) {
            this.mContext = context;
            return this;
        }

        protected abstract ReactPackageTurboModuleManagerDelegate build(ReactApplicationContext var1, List<ReactPackage> var2);

        public ReactPackageTurboModuleManagerDelegate build() {
            Assertions.assertNotNull((Object)((Object)this.mContext), (String)"The ReactApplicationContext must be provided to create ReactPackageTurboModuleManagerDelegate");
            Assertions.assertNotNull(this.mPackages, (String)"A set of ReactPackages must be provided to create ReactPackageTurboModuleManagerDelegate");
            return this.build(this.mContext, this.mPackages);
        }
    }
}

