/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;

public class DynamicFromObject
implements Dynamic {
    @Nullable
    private Object mObject;

    public DynamicFromObject(@Nullable Object obj) {
        this.mObject = obj;
    }

    @Override
    public void recycle() {
    }

    @Override
    public boolean isNull() {
        return this.mObject == null;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.mObject;
    }

    @Override
    public double asDouble() {
        return (Double)this.mObject;
    }

    @Override
    public int asInt() {
        return ((Double)this.mObject).intValue();
    }

    @Override
    public String asString() {
        return (String)this.mObject;
    }

    @Override
    public ReadableArray asArray() {
        return (ReadableArray)this.mObject;
    }

    @Override
    public ReadableMap asMap() {
        return (ReadableMap)this.mObject;
    }

    @Override
    public ReadableType getType() {
        if (this.isNull()) {
            return ReadableType.Null;
        }
        if (this.mObject instanceof Boolean) {
            return ReadableType.Boolean;
        }
        if (this.mObject instanceof Number) {
            return ReadableType.Number;
        }
        if (this.mObject instanceof String) {
            return ReadableType.String;
        }
        if (this.mObject instanceof ReadableMap) {
            return ReadableType.Map;
        }
        if (this.mObject instanceof ReadableArray) {
            return ReadableType.Array;
        }
        FLog.e((String)"ReactNative", (String)("Unmapped object type " + (this.mObject == null ? "<NULL object>" : this.mObject.getClass().getName())));
        return ReadableType.Null;
    }
}

