/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;

class LongStreamingStats {
    private final Queue<Long> minHeap = new PriorityQueue<Long>(11, Comparator.comparingLong(aLong -> aLong));
    private final Queue<Long> maxHeap = new PriorityQueue<Long>(11, (first, second) -> Long.compare(second, first));
    private double streamingAverage = 0.0;
    private int len = 0;
    private long max = 0L;

    LongStreamingStats() {
    }

    public void add(long n) {
        if (n != 0L) {
            if (this.minHeap.size() == this.maxHeap.size()) {
                this.maxHeap.offer(n);
                this.minHeap.offer(this.maxHeap.poll());
            } else {
                this.minHeap.offer(n);
                this.maxHeap.offer(this.minHeap.poll());
            }
        }
        ++this.len;
        this.streamingAverage = this.len == 1 ? (double)n : this.streamingAverage / (double)(this.len / (this.len - 1)) + (double)(n / (long)this.len);
        this.max = n > this.max ? n : this.max;
    }

    public double getMedian() {
        if (this.minHeap.size() == 0 && this.maxHeap.size() == 0) {
            return 0.0;
        }
        long median = this.minHeap.size() > this.maxHeap.size() ? this.minHeap.peek() : (this.minHeap.peek() + this.maxHeap.peek()) / 2L;
        return median;
    }

    public double getAverage() {
        return this.streamingAverage;
    }

    public long getMax() {
        return this.max;
    }
}

