/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Objects;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessAtomicRef<T> {
    @Nullable
    volatile T mValue;
    @Nullable
    T mInitialValue;
    private volatile State state;
    private volatile String failureMessage;

    public BridgelessAtomicRef(@Nullable T initialValue) {
        this.mValue = initialValue;
        this.mInitialValue = initialValue;
        this.state = State.Init;
        this.failureMessage = "";
    }

    public BridgelessAtomicRef() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"CatchGeneralException"})
    public T getOrCreate(Provider<T> provider) {
        boolean shouldCreate = false;
        BridgelessAtomicRef bridgelessAtomicRef = this;
        synchronized (bridgelessAtomicRef) {
            if (this.state == State.Success) {
                return this.get();
            }
            if (this.state == State.Failure) {
                throw new RuntimeException("BridgelessAtomicRef: Failed to create object. Reason: " + this.failureMessage);
            }
            if (this.state != State.Creating) {
                this.state = State.Creating;
                shouldCreate = true;
            }
        }
        if (shouldCreate) {
            try {
                this.mValue = provider.get();
                bridgelessAtomicRef = this;
                synchronized (bridgelessAtomicRef) {
                    this.state = State.Success;
                    this.notifyAll();
                    return this.get();
                }
            }
            catch (RuntimeException ex) {
                BridgelessAtomicRef bridgelessAtomicRef2 = this;
                synchronized (bridgelessAtomicRef2) {
                    this.state = State.Failure;
                    String message = ex.getMessage();
                    this.failureMessage = Objects.toString(message, "null");
                    this.notifyAll();
                }
                throw new RuntimeException("BridgelessAtomicRef: Failed to create object.", ex);
            }
        }
        bridgelessAtomicRef = this;
        synchronized (bridgelessAtomicRef) {
            boolean wasInterrupted = false;
            while (this.state == State.Creating) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    wasInterrupted = true;
                }
            }
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.state == State.Failure) {
                throw new RuntimeException("BridgelessAtomicRef: Failed to create object. Reason: " + this.failureMessage);
            }
            return this.get();
        }
    }

    public synchronized T getAndReset() {
        T value = this.get();
        this.reset();
        return value;
    }

    public synchronized void reset() {
        this.mValue = this.mInitialValue;
        this.state = State.Init;
        this.failureMessage = "";
    }

    public synchronized T get() {
        return (T)Assertions.assertNotNull(this.mValue);
    }

    @Nullable
    public synchronized T getNullable() {
        return this.mValue;
    }

    static enum State {
        Init,
        Creating,
        Success,
        Failure;

    }

    static interface Provider<T> {
        public T get();
    }
}

