/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.mapbuffer.MapBuffer;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.ViewManagerPropertyUpdater;
import com.facebook.react.uimanager.annotations.ReactPropertyHolder;
import com.facebook.yoga.YogaMeasureMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

@ReactPropertyHolder
public abstract class ViewManager<T extends View, C extends ReactShadowNode>
extends BaseJavaModule {
    private static final String NAME = ViewManager.class.getSimpleName();
    @Nullable
    private HashMap<Integer, Stack<T>> mRecyclableViews = null;

    public ViewManager() {
        super(null);
    }

    public ViewManager(@Nullable ReactApplicationContext reactContext) {
        super(reactContext);
    }

    protected void setupViewRecycling() {
        if (ReactNativeFeatureFlags.enableViewRecycling()) {
            this.mRecyclableViews = new HashMap();
        }
    }

    @Nullable
    private Stack<T> getRecyclableViewStack(int surfaceId, boolean create) {
        if (this.mRecyclableViews == null) {
            return null;
        }
        if (create && !this.mRecyclableViews.containsKey(surfaceId)) {
            this.mRecyclableViews.put(surfaceId, new Stack());
        }
        return this.mRecyclableViews.get(surfaceId);
    }

    public void updateProperties(@NonNull T viewToUpdate, ReactStylesDiffMap props) {
        ViewManagerDelegate<T> delegate = this.getDelegate();
        if (delegate != null) {
            ViewManagerPropertyUpdater.updateProps(delegate, viewToUpdate, props);
        } else {
            ViewManagerPropertyUpdater.updateProps(this, viewToUpdate, props);
        }
        this.onAfterUpdateTransaction(viewToUpdate);
    }

    @Nullable
    protected ViewManagerDelegate<T> getDelegate() {
        return null;
    }

    @NonNull
    public T createView(int reactTag, @NonNull ThemedReactContext reactContext, @Nullable ReactStylesDiffMap props, @Nullable StateWrapper stateWrapper, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactTag, reactContext, props, stateWrapper);
        if (view instanceof ReactInterceptingViewGroup) {
            ((ReactInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    @Override
    @NonNull
    public abstract String getName();

    public C createShadowNodeInstance() {
        throw new RuntimeException("ViewManager subclasses must implement createShadowNodeInstance()");
    }

    @NonNull
    public C createShadowNodeInstance(@NonNull ReactApplicationContext context) {
        return this.createShadowNodeInstance();
    }

    public abstract Class<? extends C> getShadowNodeClass();

    @NonNull
    protected abstract T createViewInstance(@NonNull ThemedReactContext var1);

    @NonNull
    protected T createViewInstance(int reactTag, @NonNull ThemedReactContext reactContext, @Nullable ReactStylesDiffMap initialProps, @Nullable StateWrapper stateWrapper) {
        Object extraData;
        View view = null;
        Stack<T> recyclableViews = this.getRecyclableViewStack(reactContext.getSurfaceId(), true);
        view = recyclableViews != null && !recyclableViews.empty() ? this.recycleView(reactContext, (View)recyclableViews.pop()) : (View)this.createViewInstance(reactContext);
        view.setId(reactTag);
        this.addEventEmitters(reactContext, view);
        if (initialProps != null) {
            this.updateProperties(view, initialProps);
        }
        if (stateWrapper != null && (extraData = this.updateState(view, initialProps, stateWrapper)) != null) {
            this.updateExtraData(view, extraData);
        }
        return (T)view;
    }

    public void onDropViewInstance(@NonNull T view) {
        T recyclableView;
        Context viewContext = view.getContext();
        if (viewContext == null) {
            FLog.e((String)NAME, (String)("onDropViewInstance: view [" + view.getId() + "] has a null context"));
            return;
        }
        if (!(viewContext instanceof ThemedReactContext)) {
            FLog.e((String)NAME, (String)("onDropViewInstance: view [" + view.getId() + "] has a context that is not a ThemedReactContext: " + viewContext));
            return;
        }
        ThemedReactContext themedReactContext = (ThemedReactContext)viewContext;
        int surfaceId = themedReactContext.getSurfaceId();
        Stack<T> recyclableViews = this.getRecyclableViewStack(surfaceId, false);
        if (recyclableViews != null && (recyclableView = this.prepareToRecycleView(themedReactContext, view)) != null) {
            recyclableViews.push(recyclableView);
        }
    }

    @Nullable
    protected abstract T prepareToRecycleView(@NonNull ThemedReactContext var1, @NonNull T var2);

    protected T recycleView(@NonNull ThemedReactContext reactContext, @NonNull T view) {
        return view;
    }

    protected void addEventEmitters(@NonNull ThemedReactContext reactContext, @NonNull T view) {
    }

    protected void onAfterUpdateTransaction(@NonNull T view) {
    }

    public abstract void updateExtraData(@NonNull T var1, Object var2);

    @Deprecated
    public void receiveCommand(@NonNull T root, int commandId, @Nullable ReadableArray args) {
    }

    public void receiveCommand(@NonNull T root, String commandId, @Nullable ReadableArray args) {
        ViewManagerDelegate<T> delegate = this.getDelegate();
        if (delegate != null) {
            delegate.receiveCommand(root, commandId, args);
        }
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, String> getNativeProps() {
        return ViewManagerPropertyUpdater.getNativeProps(this.getClass(), this.getShadowNodeClass());
    }

    @Nullable
    public Object updateState(@NonNull T view, ReactStylesDiffMap props, StateWrapper stateWrapper) {
        return null;
    }

    public long measure(Context context, ReadableMap localData, ReadableMap props, ReadableMap state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return 0L;
    }

    public long measure(Context context, MapBuffer localData, MapBuffer props, @Nullable MapBuffer state, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode, @Nullable float[] attachmentsPositions) {
        return 0L;
    }

    public void setPadding(T view, int left, int top, int right, int bottom) {
    }

    public void onSurfaceStopped(int surfaceId) {
        if (this.mRecyclableViews != null) {
            this.mRecyclableViews.remove(surfaceId);
        }
    }

    void trimMemory() {
        if (this.mRecyclableViews != null) {
            this.mRecyclableViews = new HashMap();
        }
    }
}

