/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.views.view.ReactViewGroup;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactHorizontalScrollContainerView
extends ReactViewGroup {
    private int mLayoutDirection;

    public ReactHorizontalScrollContainerView(Context context) {
        super(context);
        this.mLayoutDirection = I18nUtil.getInstance().isRTL(context) ? 1 : 0;
    }

    public int getLayoutDirection() {
        if (ReactNativeFeatureFlags.setAndroidLayoutDirection()) {
            return super.getLayoutDirection();
        }
        return this.mLayoutDirection;
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (this.getLayoutDirection() == 1) {
            super.setRemoveClippedSubviews(false);
            return;
        }
        super.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getLayoutDirection() == 1) {
            int newLeft = 0;
            int width = right - left;
            int newRight = newLeft + width;
            this.setLeft(newLeft);
            this.setTop(top);
            this.setRight(newRight);
            this.setBottom(bottom);
        }
    }
}

