/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/react/animated/TransformAnimatedNode;", "Lcom/facebook/react/animated/AnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "transformConfigs", "", "Lcom/facebook/react/animated/TransformAnimatedNode$TransformConfig;", "collectViewUpdates", "", "propsMap", "Lcom/facebook/react/bridge/JavaOnlyMap;", "prettyPrint", "", "AnimatedTransformConfig", "StaticTransformConfig", "TransformConfig", "ReactAndroid_release"})
public final class TransformAnimatedNode
extends AnimatedNode {
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    @NotNull
    private final List<TransformConfig> transformConfigs;

    /*
     * WARNING - void declaration
     */
    public TransformAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        List list;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        ReadableArray transforms = config.getArray("transforms");
        TransformAnimatedNode transformAnimatedNode = this;
        if (transforms == null) {
            list = new ArrayList();
        } else {
            int n = transforms.size();
            TransformAnimatedNode transformAnimatedNode2 = transformAnimatedNode;
            ArrayList<TransformConfig> arrayList = new ArrayList<TransformConfig>(n);
            for (int i = 0; i < n; ++i) {
                TransformConfig transformConfig;
                void i2;
                int n2;
                int n3 = n2 = i;
                ArrayList<TransformConfig> arrayList2 = arrayList;
                boolean bl = false;
                ReadableMap transformConfigMap = transforms.getMap((int)i2);
                String property = transformConfigMap.getString("property");
                String type = transformConfigMap.getString("type");
                if (Intrinsics.areEqual((Object)type, (Object)"animated")) {
                    transformConfig = new AnimatedTransformConfig();
                    transformConfig.setProperty(property);
                    ((AnimatedTransformConfig)transformConfig).setNodeTag(transformConfigMap.getInt("nodeTag"));
                    transformConfig = transformConfig;
                } else {
                    transformConfig = new StaticTransformConfig();
                    transformConfig.setProperty(property);
                    ((StaticTransformConfig)transformConfig).setValue(transformConfigMap.getDouble("value"));
                    transformConfig = transformConfig;
                }
                arrayList2.add(transformConfig);
            }
            list = arrayList;
            transformAnimatedNode = transformAnimatedNode2;
        }
        transformAnimatedNode.transformConfigs = list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void collectViewUpdates(@NotNull JavaOnlyMap propsMap) {
        Intrinsics.checkNotNullParameter((Object)propsMap, (String)"propsMap");
        int n = this.transformConfigs.size();
        ArrayList<JavaOnlyMap> arrayList = new ArrayList<JavaOnlyMap>(n);
        for (int i = 0; i < n; ++i) {
            double d;
            void i2;
            int n2;
            int n3 = n2 = i;
            ArrayList<JavaOnlyMap> arrayList2 = arrayList;
            boolean bl = false;
            TransformConfig transformConfig = this.transformConfigs.get((int)i2);
            if (transformConfig instanceof AnimatedTransformConfig) {
                int nodeTag = ((AnimatedTransformConfig)transformConfig).getNodeTag();
                AnimatedNode node = this.nativeAnimatedNodesManager.getNodeById(nodeTag);
                if (node == null) {
                    throw new IllegalArgumentException("Mapped style node does not exist");
                }
                if (!(node instanceof ValueAnimatedNode)) throw new IllegalArgumentException("Unsupported type of node used as a transform child node " + node.getClass());
                d = ((ValueAnimatedNode)node).getValue();
            } else {
                Intrinsics.checkNotNull((Object)transformConfig, (String)"null cannot be cast to non-null type com.facebook.react.animated.TransformAnimatedNode.StaticTransformConfig");
                d = ((StaticTransformConfig)transformConfig).getValue();
            }
            double transform = d;
            Object[] objectArray = new Object[]{transformConfig.getProperty(), transform};
            JavaOnlyMap javaOnlyMap = JavaOnlyMap.of(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)javaOnlyMap, (String)"of(...)");
            arrayList2.add(javaOnlyMap);
        }
        List transforms = arrayList;
        propsMap.putArray("transform", JavaOnlyArray.from(transforms));
    }

    @Override
    @NotNull
    public String prettyPrint() {
        return "TransformAnimatedNode[" + this.tag + "]: transformConfigs: " + this.transformConfigs;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/animated/TransformAnimatedNode$AnimatedTransformConfig;", "Lcom/facebook/react/animated/TransformAnimatedNode$TransformConfig;", "Lcom/facebook/react/animated/TransformAnimatedNode;", "(Lcom/facebook/react/animated/TransformAnimatedNode;)V", "nodeTag", "", "getNodeTag", "()I", "setNodeTag", "(I)V", "ReactAndroid_release"})
    private final class AnimatedTransformConfig
    extends TransformConfig {
        private int nodeTag;

        public final int getNodeTag() {
            return this.nodeTag;
        }

        public final void setNodeTag(int n) {
            this.nodeTag = n;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/animated/TransformAnimatedNode$StaticTransformConfig;", "Lcom/facebook/react/animated/TransformAnimatedNode$TransformConfig;", "Lcom/facebook/react/animated/TransformAnimatedNode;", "(Lcom/facebook/react/animated/TransformAnimatedNode;)V", "value", "", "getValue", "()D", "setValue", "(D)V", "ReactAndroid_release"})
    private final class StaticTransformConfig
    extends TransformConfig {
        private double value;

        public final double getValue() {
            return this.value;
        }

        public final void setValue(double d) {
            this.value = d;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0092\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/animated/TransformAnimatedNode$TransformConfig;", "", "(Lcom/facebook/react/animated/TransformAnimatedNode;)V", "property", "", "getProperty", "()Ljava/lang/String;", "setProperty", "(Ljava/lang/String;)V", "ReactAndroid_release"})
    private class TransformConfig {
        @Nullable
        private String property;

        @Nullable
        public final String getProperty() {
            return this.property;
        }

        public final void setProperty(@Nullable String string) {
            this.property = string;
        }
    }
}

