/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.WebsocketJavaScriptExecutor;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.DevSplitBundleCallback;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.packagerconnection.RequestHandler;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class BridgeDevSupportManager
extends DevSupportManagerBase {
    private boolean mIsSamplingProfilerEnabled = false;

    public BridgeDevSupportManager(Context applicationContext, ReactInstanceDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable SurfaceDelegateFactory surfaceDelegateFactory, @Nullable DevLoadingViewManager devLoadingViewManager, @Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        super(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, enableOnCreate, redBoxHandler, devBundleDownloadListener, minNumShakes, customPackagerCommandHandlers, surfaceDelegateFactory, devLoadingViewManager, pausedInDebuggerOverlayManager);
    }

    @Override
    protected String getUniqueTag() {
        return "Bridge";
    }

    @Override
    public void loadSplitBundleFromServer(final String bundlePath, final DevSplitBundleCallback callback) {
        this.fetchSplitBundleAndCreateBundleLoader(bundlePath, new DevSupportManagerBase.CallbackWithBundleLoader(){

            @Override
            public void onSuccess(JSBundleLoader bundleLoader) {
                bundleLoader.loadScript(BridgeDevSupportManager.this.getCurrentContext().getCatalystInstance());
                BridgeDevSupportManager.this.getCurrentContext().getJSModule(HMRClient.class).registerBundle(BridgeDevSupportManager.this.getDevServerHelper().getDevServerSplitBundleURL(bundlePath));
                callback.onSuccess();
            }

            @Override
            public void onError(String url, Throwable cause) {
                callback.onError(url, cause);
            }
        });
    }

    private WebsocketJavaScriptExecutor.JSExecutorConnectCallback getExecutorConnectCallback(final SimpleSettableFuture<Boolean> future) {
        return new WebsocketJavaScriptExecutor.JSExecutorConnectCallback(){

            @Override
            public void onSuccess() {
                future.set(true);
                BridgeDevSupportManager.this.hideDevLoadingView();
            }

            @Override
            public void onFailure(Throwable cause) {
                BridgeDevSupportManager.this.hideDevLoadingView();
                FLog.e((String)"ReactNative", (String)"Failed to connect to debugger!", (Throwable)cause);
                future.setException(new IOException(BridgeDevSupportManager.this.getApplicationContext().getString(R.string.catalyst_debug_error), cause));
            }
        };
    }

    private void reloadJSInProxyMode() {
        this.getDevServerHelper().launchJSDevtools();
        JavaJSExecutor.Factory factory = new JavaJSExecutor.Factory(){

            @Override
            public JavaJSExecutor create() throws Exception {
                WebsocketJavaScriptExecutor executor = new WebsocketJavaScriptExecutor();
                SimpleSettableFuture<Boolean> future = new SimpleSettableFuture<Boolean>();
                executor.connect(BridgeDevSupportManager.this.getDevServerHelper().getWebsocketProxyURL(), BridgeDevSupportManager.this.getExecutorConnectCallback(future));
                try {
                    future.get(90L, TimeUnit.SECONDS);
                    return executor;
                }
                catch (ExecutionException e) {
                    throw (Exception)e.getCause();
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.getReactInstanceDevHelper().onReloadWithJSDebugger(factory);
    }

    @Override
    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker(ReactMarkerConstants.RELOAD, this.getDevSettings().getPackagerConnectionSettings().getDebugServerHost());
        this.hideRedboxDialog();
        if (this.getDevSettings().isRemoteJSDebugEnabled()) {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from Proxy");
            this.showDevLoadingViewForRemoteJSEnabled();
            this.reloadJSInProxyMode();
        } else {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from Server");
            String bundleURL = this.getDevServerHelper().getDevServerBundleURL((String)Assertions.assertNotNull((Object)this.getJSAppBundleName()));
            this.reloadJSFromServer(bundleURL, () -> UiThreadUtil.runOnUiThread(() -> this.getReactInstanceDevHelper().onJSBundleLoadedFromServer()));
        }
    }
}

