/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.util.Supplier;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;

class PausedInDebuggerOverlayDialogManager
implements PausedInDebuggerOverlayManager {
    private final Supplier<Context> mContextSupplier;
    @Nullable
    private Dialog mPausedInDebuggerDialog;

    public PausedInDebuggerOverlayDialogManager(Supplier<Context> contextSupplier) {
        this.mContextSupplier = contextSupplier;
    }

    @Override
    public void showPausedInDebuggerOverlay(String message, DevSupportManager.PausedInDebuggerOverlayCommandListener listener) {
        UiThreadUtil.runOnUiThread(() -> {
            Context context;
            if (this.mPausedInDebuggerDialog != null) {
                this.mPausedInDebuggerDialog.dismiss();
            }
            if ((context = (Context)this.mContextSupplier.get()) == null) {
                return;
            }
            View dialogView = LayoutInflater.from((Context)context).inflate(R.layout.paused_in_debugger_view, null);
            View resumeButton = (View)Assertions.assertNotNull((Object)dialogView.findViewById(R.id.button));
            resumeButton.setOnClickListener(v -> listener.onResume());
            TextView buttonText = (TextView)Assertions.assertNotNull((Object)((TextView)dialogView.findViewById(R.id.button_text)));
            buttonText.setText((CharSequence)message);
            this.mPausedInDebuggerDialog = new Dialog(context, R.style.NoAnimationDialog);
            this.mPausedInDebuggerDialog.setContentView(dialogView);
            this.mPausedInDebuggerDialog.setCancelable(false);
            Window dialogWindow = this.mPausedInDebuggerDialog.getWindow();
            if (dialogWindow != null) {
                WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
                layoutParams.dimAmount = 0.2f;
                dialogWindow.setAttributes(layoutParams);
                dialogWindow.addFlags(2);
                dialogWindow.setGravity(48);
                dialogWindow.setElevation(0.0f);
                dialogWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
                dialogWindow.setBackgroundDrawableResource(R.drawable.paused_in_debugger_background);
            }
            this.mPausedInDebuggerDialog.show();
        });
    }

    @Override
    public void hidePausedInDebuggerOverlay() {
        UiThreadUtil.runOnUiThread(() -> {
            if (this.mPausedInDebuggerDialog != null) {
                this.mPausedInDebuggerDialog.dismiss();
                this.mPausedInDebuggerDialog = null;
            }
        });
    }
}

