/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.devsupport.RedBoxContentView;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import java.util.Objects;

class RedBoxDialogSurfaceDelegate
implements SurfaceDelegate {
    private final DoubleTapReloadRecognizer mDoubleTapReloadRecognizer;
    private final DevSupportManager mDevSupportManager;
    @Nullable
    private Dialog mDialog;
    @Nullable
    private RedBoxContentView mRedBoxContentView;

    public RedBoxDialogSurfaceDelegate(DevSupportManager devSupportManager) {
        this.mDevSupportManager = devSupportManager;
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
    }

    @Override
    public void createContentView(String appKey) {
        RedBoxHandler redBoxHandler = this.mDevSupportManager.getRedBoxHandler();
        Activity context = this.mDevSupportManager.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            String message = this.mDevSupportManager.getLastErrorTitle();
            FLog.e((String)"ReactNative", (String)("Unable to launch redbox because react activity is not available, here is the error that redbox would've displayed: " + (message != null ? message : "N/A")));
            return;
        }
        this.mRedBoxContentView = new RedBoxContentView((Context)context);
        this.mRedBoxContentView.setDevSupportManager(this.mDevSupportManager).setRedBoxHandler(redBoxHandler).init();
    }

    @Override
    public boolean isContentViewReady() {
        return this.mRedBoxContentView != null;
    }

    @Override
    public void destroyContentView() {
        this.mRedBoxContentView = null;
    }

    @Override
    public void show() {
        String message = this.mDevSupportManager.getLastErrorTitle();
        Activity context = this.mDevSupportManager.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)("Unable to launch redbox because react activity is not available, here is the error that redbox would've displayed: " + (message != null ? message : "N/A")));
            return;
        }
        if (this.mRedBoxContentView == null || this.mRedBoxContentView.getContext() != context) {
            this.createContentView("RedBox");
        }
        this.mRedBoxContentView.refreshContentView();
        if (this.mDialog == null) {
            this.mDialog = new Dialog((Context)context, R.style.Theme_Catalyst_RedBox){

                public boolean onKeyUp(int keyCode, KeyEvent event) {
                    if (keyCode == 82) {
                        RedBoxDialogSurfaceDelegate.this.mDevSupportManager.showDevOptionsDialog();
                        return true;
                    }
                    if (RedBoxDialogSurfaceDelegate.this.mDoubleTapReloadRecognizer.didDoubleTapR(keyCode, this.getCurrentFocus())) {
                        RedBoxDialogSurfaceDelegate.this.mDevSupportManager.handleReloadJS();
                    }
                    return super.onKeyUp(keyCode, event);
                }

                protected void onCreate(Bundle savedInstanceState) {
                    Objects.requireNonNull(this.getWindow());
                    this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(-16777216));
                    int insetsType = WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout();
                    ViewCompat.setOnApplyWindowInsetsListener((View)RedBoxDialogSurfaceDelegate.this.mRedBoxContentView, (view, windowInsetsCompat) -> {
                        Insets insets = windowInsetsCompat.getInsets(insetsType);
                        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
                        lp.setMargins(insets.left, insets.top, insets.right, insets.bottom);
                        return WindowInsetsCompat.CONSUMED;
                    });
                }
            };
            this.mDialog.requestWindowFeature(1);
            this.mDialog.setContentView((View)this.mRedBoxContentView);
        }
        this.mDialog.show();
    }

    @Override
    public void hide() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.destroyContentView();
            this.mDialog = null;
        }
    }

    @Override
    public boolean isShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }
}

