/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.util.Log;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.common.annotations.FrameworkAPI;
import com.facebook.react.common.annotations.UnstableReactNativeAPI;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.runtime.BridgelessCatalystInstance;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessReactContext
extends ReactApplicationContext
implements EventDispatcherProvider {
    private final ReactHostImpl mReactHost;
    private final AtomicReference<String> mSourceURL = new AtomicReference();
    private final String TAG = this.getClass().getSimpleName();

    BridgelessReactContext(Context context, ReactHostImpl host) {
        super(context);
        this.mReactHost = host;
        if (ReactNativeFeatureFlags.useFabricInterop()) {
            this.initializeInteropModules();
        }
    }

    @Override
    public boolean isBridgeless() {
        return true;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.mReactHost.getEventDispatcher();
    }

    public void setSourceURL(String sourceURL) {
        this.mSourceURL.set(sourceURL);
    }

    @Override
    @Nullable
    public String getSourceURL() {
        return this.mSourceURL.get();
    }

    @Override
    @Nullable
    public UIManager getFabricUIManager() {
        return this.mReactHost.getUIManager();
    }

    @Override
    public CatalystInstance getCatalystInstance() {
        Log.w((String)this.TAG, (String)"[WARNING] Bridgeless doesn't support CatalystInstance. Accessing an API that's not part of the new architecture is not encouraged usage.");
        return new BridgelessCatalystInstance(this.mReactHost);
    }

    @Override
    @Deprecated
    public boolean hasActiveCatalystInstance() {
        return this.hasActiveReactInstance();
    }

    @Override
    public boolean hasActiveReactInstance() {
        return this.mReactHost.isInstanceInitialized();
    }

    @Override
    public boolean hasCatalystInstance() {
        return false;
    }

    @Override
    public boolean hasReactInstance() {
        return this.mReactHost.isInstanceInitialized();
    }

    @Override
    public void destroy() {
    }

    DevSupportManager getDevSupportManager() {
        return this.mReactHost.getDevSupportManager();
    }

    @Override
    public void registerSegment(int segmentId, String path, Callback callback) {
        this.mReactHost.registerSegment(segmentId, path, callback);
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        if (this.mInteropModuleRegistry != null && this.mInteropModuleRegistry.shouldReturnInteropModule(jsInterface)) {
            return this.mInteropModuleRegistry.getInteropModule(jsInterface);
        }
        JavaScriptModule interfaceProxy = (JavaScriptModule)Proxy.newProxyInstance(jsInterface.getClassLoader(), new Class[]{jsInterface}, (InvocationHandler)new BridgelessJSModuleInvocationHandler(this.mReactHost, jsInterface));
        return (T)interfaceProxy;
    }

    @Override
    public void emitDeviceEvent(String eventName, @Nullable Object args) {
        this.mReactHost.callFunctionOnModule("RCTDeviceEventEmitter", "emit", Arguments.fromJavaArgs(new Object[]{eventName, args}));
    }

    @Override
    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        return this.mReactHost.hasNativeModule(nativeModuleInterface);
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        return this.mReactHost.getNativeModules();
    }

    @Override
    @Nullable
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return this.mReactHost.getNativeModule(nativeModuleInterface);
    }

    @Override
    @Nullable
    public NativeModule getNativeModule(String name) {
        return this.mReactHost.getNativeModule(name);
    }

    @Override
    @FrameworkAPI
    @UnstableReactNativeAPI
    @Nullable
    public JavaScriptContextHolder getJavaScriptContextHolder() {
        return this.mReactHost.getJavaScriptContextHolder();
    }

    @Override
    public void handleException(Exception e) {
        this.mReactHost.handleHostException(e);
    }

    @Override
    @Nullable
    public CallInvokerHolder getJSCallInvokerHolder() {
        return this.mReactHost.getJSCallInvokerHolder();
    }

    DefaultHardwareBackBtnHandler getDefaultHardwareBackBtnHandler() {
        return this.mReactHost.getDefaultBackButtonHandler();
    }

    private static class BridgelessJSModuleInvocationHandler
    implements InvocationHandler {
        private final ReactHostImpl mReactHost;
        private final Class<? extends JavaScriptModule> mJSModuleInterface;

        public BridgelessJSModuleInvocationHandler(ReactHostImpl reactHost, Class<? extends JavaScriptModule> jsModuleInterface) {
            this.mReactHost = reactHost;
            this.mJSModuleInterface = jsModuleInterface;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, @Nullable Object[] args) {
            WritableNativeArray jsArgs = args != null ? Arguments.fromJavaArgs(args) : new WritableNativeArray();
            this.mReactHost.callFunctionOnModule(JavaScriptModuleRegistry.getJSModuleName(this.mJSModuleInterface), method.getName(), jsArgs);
            return null;
        }
    }
}

