/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.uimanager.RootView;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/facebook/react/uimanager/RootViewUtil;", "", "()V", "getRootView", "Lcom/facebook/react/uimanager/RootView;", "reactView", "Landroid/view/View;", "getViewportOffset", "Landroid/graphics/Point;", "v", "ReactAndroid_release"})
public final class RootViewUtil {
    @NotNull
    public static final RootViewUtil INSTANCE = new RootViewUtil();

    private RootViewUtil() {
    }

    @JvmStatic
    @Nullable
    public static final RootView getRootView(@NotNull View reactView) {
        Intrinsics.checkNotNullParameter((Object)reactView, (String)"reactView");
        View current = reactView;
        while (!(current instanceof RootView)) {
            ViewParent next2;
            if (current.getParent() == null) {
                return null;
            }
            Assertions.assertCondition((boolean)(next2 instanceof View));
            current = (View)next2;
        }
        return (RootView)current;
    }

    @JvmStatic
    @UiThread
    @NotNull
    public static final Point getViewportOffset(@NotNull View v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int[] locationInWindow = new int[2];
        v.getLocationInWindow(locationInWindow);
        Rect visibleWindowFrame = new Rect();
        v.getWindowVisibleDisplayFrame(visibleWindowFrame);
        locationInWindow[0] = locationInWindow[0] - visibleWindowFrame.left;
        locationInWindow[1] = locationInWindow[1] - visibleWindowFrame.top;
        return new Point(locationInWindow[0], locationInWindow[1]);
    }
}

