/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.OpacityAnimation;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
abstract class BaseLayoutAnimation
extends AbstractLayoutAnimation {
    BaseLayoutAnimation() {
    }

    abstract boolean isReverse();

    @Override
    boolean isValid() {
        return this.mDurationMs > 0 && this.mAnimatedProperty != null;
    }

    @Override
    Animation createAnimationImpl(View view, int x, int y, int width, int height) {
        if (this.mAnimatedProperty != null) {
            switch (this.mAnimatedProperty) {
                case OPACITY: {
                    float fromValue = this.isReverse() ? view.getAlpha() : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : view.getAlpha();
                    return new OpacityAnimation(view, fromValue, toValue);
                }
                case SCALE_XY: {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    return new ScaleAnimation(fromValue, toValue, fromValue, toValue, 1, 0.5f, 1, 0.5f);
                }
                case SCALE_X: {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    return new ScaleAnimation(fromValue, toValue, 1.0f, 1.0f, 1, 0.5f, 1, 0.0f);
                }
                case SCALE_Y: {
                    float fromValue = this.isReverse() ? 1.0f : 0.0f;
                    float toValue = this.isReverse() ? 0.0f : 1.0f;
                    return new ScaleAnimation(1.0f, 1.0f, fromValue, toValue, 1, 0.0f, 1, 0.5f);
                }
            }
            throw new IllegalViewOperationException("Missing animation for property : " + (Object)((Object)this.mAnimatedProperty));
        }
        throw new IllegalViewOperationException("Missing animated property from animation config");
    }
}

