/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.View;
import android.widget.ProgressBar;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/views/progressbar/ProgressBarShadowNode;", "Lcom/facebook/react/uimanager/LayoutShadowNode;", "Lcom/facebook/yoga/YogaMeasureFunction;", "()V", "height", "Landroid/util/SparseIntArray;", "measured", "", "", "value", "", "style", "getStyle", "()Ljava/lang/String;", "setStyle", "(Ljava/lang/String;)V", "width", "measure", "", "node", "Lcom/facebook/yoga/YogaNode;", "", "widthMode", "Lcom/facebook/yoga/YogaMeasureMode;", "heightMode", "ReactAndroid_release"})
public final class ProgressBarShadowNode
extends LayoutShadowNode
implements YogaMeasureFunction {
    @NotNull
    private final SparseIntArray height = new SparseIntArray();
    @NotNull
    private final SparseIntArray width = new SparseIntArray();
    @NotNull
    private final Set<Integer> measured = new HashSet();
    @Nullable
    private String style;

    public ProgressBarShadowNode() {
        this.setMeasureFunction(this);
        this.style = "Normal";
    }

    @Nullable
    public final String getStyle() {
        return this.style;
    }

    @ReactProp(name="styleAttr")
    public final void setStyle(@Nullable String value) {
        String string2 = value;
        if (string2 == null) {
            string2 = "Normal";
        }
        this.style = string2;
    }

    @Override
    public long measure(@NotNull YogaNode node, float width, @NotNull YogaMeasureMode widthMode, float height, @NotNull YogaMeasureMode heightMode) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)widthMode), (String)"widthMode");
        Intrinsics.checkNotNullParameter((Object)((Object)heightMode), (String)"heightMode");
        int style2 = ReactProgressBarViewManager.Companion.getStyleFromString$ReactAndroid_release(this.style);
        if (!this.measured.contains(style2)) {
            ProgressBar progressBar = ReactProgressBarViewManager.Companion.createProgressBar((Context)this.getThemedContext(), style2);
            int spec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)0);
            progressBar.measure(spec, spec);
            this.height.put(style2, progressBar.getMeasuredHeight());
            this.width.put(style2, progressBar.getMeasuredWidth());
            this.measured.add(style2);
        }
        return YogaMeasureOutput.make(this.width.get(style2), this.height.get(style2));
    }
}

