/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionEvent;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.LocalTransaction;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tranql.connector.DissociatableConnectionHandle;
import org.tranql.connector.DissociatableConnectionHandleFactory;
import org.tranql.connector.ExceptionSorter;
import org.tranql.connector.ManagedConnectionHandle;
import org.tranql.connector.UserPasswordHandleFactoryRequestInfo;

public abstract class AbstractManagedConnection<T, U>
implements ManagedConnection,
ManagedConnectionHandle<T, U>,
DissociatableManagedConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractManagedConnection.class);
    protected final ManagedConnectionFactory mcf;
    protected final T physicalConnection;
    protected final LinkedList<DissociatableConnectionHandle<T, U>> handles = new LinkedList();
    protected final ArrayList<ConnectionEventListener> listeners = new ArrayList(2);
    private final ExceptionSorter exceptionSorter;
    protected PrintWriter log;
    protected Subject subject;
    protected ConnectionRequestInfo cri;

    public AbstractManagedConnection(ManagedConnectionFactory mcf, T physicalConnection, ExceptionSorter exceptionSorter) {
        assert (exceptionSorter != null);
        this.mcf = mcf;
        this.physicalConnection = physicalConnection;
        this.exceptionSorter = exceptionSorter;
    }

    @Override
    public T getPhysicalConnection() {
        return this.physicalConnection;
    }

    public void cleanup() throws ResourceException {
        LOGGER.trace("cleanup()");
        this.dissociateConnections();
    }

    public void destroy() throws ResourceException {
        LOGGER.trace("destroy()");
        this.dissociateConnections();
        this.listeners.clear();
        this.closePhysicalConnection();
    }

    protected abstract void closePhysicalConnection() throws ResourceException;

    public void associateConnection(Object o) throws ResourceException {
        assert (o instanceof DissociatableConnectionHandle) : "Attempt to associate incompatible handle: " + o;
        DissociatableConnectionHandle handle = (DissociatableConnectionHandle)o;
        ManagedConnectionHandle mc = handle.getAssociation();
        if (mc instanceof AbstractManagedConnection) {
            ((AbstractManagedConnection)mc).handles.remove(handle);
        }
        handle.setAssociation(this);
        this.handles.add(handle);
    }

    public void dissociateConnections() throws ResourceException {
        while (!this.handles.isEmpty()) {
            DissociatableConnectionHandle handle = this.handles.removeFirst();
            handle.setAssociation(null);
        }
    }

    @Override
    public void connectionClosed(U handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle(handle);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener listener = this.listeners.get(i);
            listener.connectionClosed(event);
        }
    }

    @Override
    public void connectionError(Exception e) {
        if (this.exceptionSorter.isExceptionFatal(e)) {
            if (this.exceptionSorter.rollbackOnFatalException()) {
                this.attemptRollback();
            }
            this.unfilteredConnectionError(e);
        }
    }

    protected void attemptRollback() {
    }

    protected void unfilteredConnectionError(Exception e) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, e);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ConnectionEventListener listener = this.listeners.get(i);
            listener.connectionErrorOccurred(event);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.log = printWriter;
    }

    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ConnectionEventListener listener = this.listeners.get(i);
                listener.localTransactionStarted(event);
            }
        }
    }

    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                ConnectionEventListener listener = this.listeners.get(i);
                listener.localTransactionCommitted(event);
            }
        }
    }

    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        if (!isSPI) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
            for (int i = 0; i < this.listeners.size(); ++i) {
                ConnectionEventListener listener = this.listeners.get(i);
                listener.localTransactionRolledback(event);
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        DissociatableConnectionHandleFactory handleFactory = ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getConnectionHandleFactory();
        DissociatableConnectionHandle handle = handleFactory.newHandle(connectionRequestInfo);
        handle.setAssociation(this);
        this.handles.add(handle);
        this.subject = subject;
        this.cri = connectionRequestInfo;
        return handle;
    }

    protected class LocalTransactionImpl
    implements LocalTransaction {
        private final boolean isSPI;

        public LocalTransactionImpl(boolean isSPI) {
            this.isSPI = isSPI;
        }

        public void begin() throws ResourceException {
            LOGGER.trace("begin(), isSPI: {}, wrapped: {}", (Object)this.isSPI, AbstractManagedConnection.this.physicalConnection);
            AbstractManagedConnection.this.localTransactionStart(this.isSPI);
        }

        public void commit() throws ResourceException {
            LOGGER.trace("commit(), isSPI: {}, wrapped: {}", (Object)this.isSPI, AbstractManagedConnection.this.physicalConnection);
            AbstractManagedConnection.this.localTransactionCommit(this.isSPI);
        }

        public void rollback() throws ResourceException {
            LOGGER.trace("rollback(), isSPI: {}, wrapped: {}", (Object)this.isSPI, AbstractManagedConnection.this.physicalConnection);
            AbstractManagedConnection.this.localTransactionRollback(this.isSPI);
        }
    }
}

