/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector;

import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ResourceAdapterInternalException;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.Subject;
import org.tranql.connector.UserPasswordHandleFactoryRequestInfo;
import org.tranql.connector.UserPasswordManagedConnectionFactory;

public class CredentialExtractor {
    private final String userName;
    private final String password;

    public CredentialExtractor(Subject subject, ConnectionRequestInfo connectionRequestInfo, UserPasswordManagedConnectionFactory managedConnectionFactory) throws ResourceAdapterInternalException {
        assert (managedConnectionFactory != null);
        if (connectionRequestInfo != null && !(connectionRequestInfo instanceof UserPasswordHandleFactoryRequestInfo)) {
            throw new ResourceAdapterInternalException("ConnectionRequestInfo must be a UserPasswordHandleFactoryRequestInfo, not a " + connectionRequestInfo.getClass().getName());
        }
        if (subject != null) {
            Set<PasswordCredential> credentials = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : credentials) {
                if (!managedConnectionFactory.equals(passwordCredential.getManagedConnectionFactory())) continue;
                this.userName = passwordCredential.getUserName();
                this.password = new String(passwordCredential.getPassword());
                return;
            }
            throw new ResourceAdapterInternalException("No credential found for this ManagedConnectionFactory: " + managedConnectionFactory);
        }
        if (connectionRequestInfo != null && ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getUser() != null) {
            this.userName = ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getUser();
            this.password = ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getPassword();
            return;
        }
        this.userName = managedConnectionFactory.getUserName();
        this.password = managedConnectionFactory.getPassword();
    }

    public boolean matches(Subject subject, ConnectionRequestInfo connectionRequestInfo, UserPasswordManagedConnectionFactory managedConnectionFactory) throws ResourceAdapterInternalException {
        assert (managedConnectionFactory != null);
        if (connectionRequestInfo != null && !(connectionRequestInfo instanceof UserPasswordHandleFactoryRequestInfo)) {
            throw new ResourceAdapterInternalException("ConnectionRequestInfo must be a UserPasswordHandleFactoryRequestInfo, not a " + connectionRequestInfo.getClass().getName());
        }
        if (subject != null) {
            Set<PasswordCredential> credentials = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : credentials) {
                if (!managedConnectionFactory.equals(passwordCredential.getManagedConnectionFactory())) continue;
                return this.userName == null ? passwordCredential.getUserName() == null : this.userName.equals(passwordCredential.getUserName()) && (this.password == null ? passwordCredential.getPassword() == null : Arrays.equals(this.password.toCharArray(), passwordCredential.getPassword()));
            }
            throw new ResourceAdapterInternalException("No credential found for this ManagedConnectionFactory: " + managedConnectionFactory);
        }
        if (connectionRequestInfo != null && ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getUser() != null) {
            return this.userName.equals(((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getUser()) && (this.password == null ? ((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getPassword() == null : this.password.equals(((UserPasswordHandleFactoryRequestInfo)connectionRequestInfo).getPassword()));
        }
        return this.userName == null ? managedConnectionFactory.getUserName() == null : this.userName.equals(managedConnectionFactory.getUserName()) && (this.password == null ? managedConnectionFactory.getPassword() == null : this.password.equals(managedConnectionFactory.getPassword()));
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

