/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.SQLException;
import java.util.Collection;
import org.tranql.connector.ExceptionSorter;

public class ConfigurableSQLStateExceptionSorter
implements ExceptionSorter {
    private final Collection<?> allowed;

    public ConfigurableSQLStateExceptionSorter(Collection<?> allowed) {
        this.allowed = allowed;
    }

    @Override
    public boolean isExceptionFatal(Exception e) {
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            String sqlState = se.getSQLState();
            return this.checkSQLState(sqlState);
        }
        return true;
    }

    protected boolean checkSQLState(String sqlState) {
        return !this.allowed.contains(sqlState);
    }

    @Override
    public boolean rollbackOnFatalException() {
        return true;
    }
}

