/*
 * Decompiled with CFR 0.152.
 */
package org.tranql.connector.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tranql.connector.jdbc.PreparedStatementKey;
import org.tranql.connector.jdbc.PreparedStatementWrapper;
import org.tranql.connector.jdbc.TranqlDataSource;

public class ConnectionWrapper
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(TranqlDataSource.class);
    private boolean ISOLATION_CACHING_ENABLED = false;
    static final int DEFAULT_STMT_CACHE_SIZE = 0;
    Connection connection;
    private HashMap<PreparedStatementKey, PreparedStatementWrapper> pStmtCache;
    private int maxCacheSize = 0;
    private boolean caching = false;
    private int cacheSize = 0;
    private int isolationLevel = 0;

    public ConnectionWrapper(Connection connection) {
        this(connection, 0);
    }

    public ConnectionWrapper(Connection connection, int cacheSize) {
        this.connection = connection;
        int n = this.maxCacheSize = cacheSize <= 0 ? 0 : cacheSize;
        if (this.maxCacheSize > 0) {
            this.caching = true;
            this.pStmtCache = new HashMap(this.maxCacheSize * 2);
        }
        try {
            this.isolationLevel = connection.getTransactionIsolation();
            this.ISOLATION_CACHING_ENABLED = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, resultSetType, resultSetConcurrency);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, autoGeneratedKeys);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, autoGeneratedKeys);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, columnIndexes);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, columnIndexes);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, columnIndexes);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (!this.caching) {
            return this.connection.prepareStatement(sql, columnNames);
        }
        PreparedStatementKey psk = new PreparedStatementKey(this, sql, columnNames);
        PreparedStatementWrapper psw = this.pStmtCache.get(psk);
        if (psw == null) {
            long startTime = System.currentTimeMillis();
            PreparedStatement ps = this.connection.prepareStatement(sql, columnNames);
            long endTime = System.currentTimeMillis();
            psw = new PreparedStatementWrapper(this, sql, ps, endTime - startTime);
            psk.setPreparedStatementWrapper(psw);
            this.addStatementToCache(psk, psw);
        }
        psw.checkOutStatement();
        return psw;
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        return this.connection.isValid(i);
    }

    @Override
    public void setClientInfo(String s, String s1) throws SQLClientInfoException {
        this.connection.setClientInfo(s, s1);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        return this.connection.getClientInfo(s);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        return this.connection.createArrayOf(s, objects);
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        return this.connection.createStruct(s, objects);
    }

    void addStatementToCache(PreparedStatementKey psk, PreparedStatementWrapper psw) {
        if (!this.caching) {
            return;
        }
        if (this.cacheSize >= this.maxCacheSize) {
            this.evictStatement();
        }
        this.pStmtCache.put(psk, psw);
        ++this.cacheSize;
    }

    private void evictStatement() {
        Iterator<PreparedStatementKey> keyList = this.pStmtCache.keySet().iterator();
        PreparedStatementKey oldestPsk = null;
        PreparedStatementKey currentPsk = null;
        PreparedStatementWrapper oldestPsw = null;
        PreparedStatementWrapper currentPsw = null;
        while (true) {
            if (keyList.hasNext()) {
                currentPsk = keyList.next();
            } else if (oldestPsk != null) break;
            if (oldestPsk == null) {
                oldestPsk = currentPsk;
                continue;
            }
            oldestPsw = oldestPsk.getPreparedStatementWrapper();
            currentPsw = currentPsk.getPreparedStatementWrapper();
            if (oldestPsw.getTimesUsed() > currentPsw.getTimesUsed()) {
                oldestPsk = currentPsk;
                continue;
            }
            if (oldestPsw.getTimesUsed() != currentPsw.getTimesUsed() || oldestPsw.getLastTimeUsed() <= currentPsw.getLastTimeUsed()) continue;
            oldestPsk = currentPsk;
        }
        this.pStmtCache.remove(oldestPsk);
        oldestPsk.getPreparedStatementWrapper().closeStatement();
        log.info("Statement --> " + oldestPsk.sql + " <-- is removed from PreparedStatement Cache");
    }

    public void returnStatementToCache(PreparedStatementWrapper psw) {
        if (psw.decrementUseCount() < 0L) {
            log.error("Counting error in PreparedStatementCaching System.\n" + psw.toString());
        }
    }

    @Override
    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        if (this.ISOLATION_CACHING_ENABLED && this.isolationLevel == isolationLevel) {
            return;
        }
        this.connection.setTransactionIsolation(isolationLevel);
        this.isolationLevel = isolationLevel;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.ISOLATION_CACHING_ENABLED ? this.isolationLevel : this.connection.getTransactionIsolation();
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        return this.connection.prepareCall(arg0);
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        return this.connection.nativeSQL(arg0);
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        this.connection.setAutoCommit(arg0);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.connection.setReadOnly(arg0);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        this.connection.setCatalog(arg0);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        return this.connection.createStatement(arg0, arg1);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        return this.connection.prepareCall(arg0, arg1, arg2);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        this.connection.setHoldability(arg0);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        return this.connection.setSavepoint(arg0);
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        this.connection.releaseSavepoint(arg0);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        return this.connection.createStatement(arg0, arg1, arg2);
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        return this.connection.prepareCall(arg0, arg1, arg2, arg3);
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        return this.connection.unwrap(tClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        return this.connection.isWrapperFor(aClass);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }
}

