/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.test.AndroidTestCase;
import com.feedhenry.sdk.utils.DataManager;
import org.json.fh.JSONObject;

public class DataManagerTest
extends AndroidTestCase {
    private static final String TRACKID = "faketrackid";

    private void removeAll() {
        SharedPreferences prefs = this.getContext().getSharedPreferences("fhsdkprivatedata", 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.commit();
    }

    public void setUp() {
        DataManager.init((Context)this.getContext());
        this.removeAll();
    }

    public void tearDown() {
        this.removeAll();
    }

    public void testMigrateData() {
        DataManager dm = DataManager.getInstance();
        String initData = dm.read("init");
        DataManagerTest.assertNull((Object)initData);
        this.createLegacyInitData();
        dm.migrateLegacyData();
        initData = dm.read("init");
        DataManagerTest.assertNotNull((Object)initData);
        JSONObject initObj = new JSONObject(initData);
        DataManagerTest.assertTrue((boolean)initObj.has("trackId"));
        DataManagerTest.assertEquals((String)TRACKID, (String)initObj.getString("trackId"));
    }

    public void testDataManager() {
        DataManager dm = DataManager.getInstance();
        String testKey = "testkey";
        String testValue = "testValue";
        String saved = dm.read(testKey);
        DataManagerTest.assertNull((Object)saved);
        dm.save(testKey, testValue);
        saved = dm.read(testKey);
        DataManagerTest.assertEquals((String)saved, (String)testValue);
        dm.remove(testKey);
        saved = dm.read(testKey);
        DataManagerTest.assertNull((Object)saved);
    }

    private void createLegacyInitData() {
        SharedPreferences prefs = this.getContext().getSharedPreferences("init", 0);
        JSONObject initObj = new JSONObject().put("trackId", (Object)TRACKID);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString("init", initObj.toString());
        edit.commit();
    }
}

