/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.test.AndroidTestCase;
import com.feedhenry.sdk.FH;
import com.feedhenry.sdk.FHActCallback;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.api.FHAuthRequest;
import com.feedhenry.sdk.api.FHAuthSession;
import com.feedhenry.sdk.tests.sync.FHTestUtils;
import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mockito.Mockito;

public class FHAuthRequestTest
extends AndroidTestCase {
    private MockWebServer mockWebServer = null;

    public void setUp() throws Exception {
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.play(9000);
        System.setProperty("dexmaker.dexcache", this.getContext().getCacheDir().getPath());
        FH.init((Context)this.getContext(), null);
    }

    public void tearDown() throws Exception {
        this.mockWebServer.shutdown();
        Thread.sleep(100L);
    }

    public void testFHAuthRequest() throws Exception {
        MockResponse cloudSuccessResponse = new MockResponse();
        cloudSuccessResponse.addHeader("Content-Type", (Object)"application/json");
        cloudSuccessResponse.setBody("{'status':'ok', 'sessionToken': 'testSessionToken'}");
        this.mockWebServer.enqueue(cloudSuccessResponse);
        FHAuthRequest authRequest = new FHAuthRequest(this.getContext());
        authRequest.setPresentingActivity(this.getContext());
        authRequest.setAuthUser("testAuthPolicy", "test", "test");
        authRequest.execute(new FHActCallback(){

            public void success(FHResponse pResponse) {
            }

            public void fail(FHResponse pResponse) {
            }
        });
        FHAuthRequestTest.assertTrue((boolean)FHAuthSession.exists());
    }

    public void testOnReceiveLogsInOAuthRequestWhenSuccessIsFollowedByAHash() {
        String googleResponse = "https://testing.feedhenry.me/box/srv/1.1/arm/authCallback?fh_auth_session=j6wnpwpb2xjn2a7quutrxubz&authResponse={\"authToken\":\"testToken\",\"email\":\"TestEmail\",\"family_name\":\"Henry\",\"gender\":\"male\",\"given_name\":\"Feed\",\"hd\":\"feedhenry.com\",\"id\":\"8675309\",\"link\":\"https://plus.google.com/8675309\",\"name\":\"Feed Henry\",\"picture\":\"http://www.feedhenry.com/wp-content/uploads/2015/01/fh-rh-top-logo-sm.png\",\"verified_email\":true}&status=complete&result=success#";
        FHAuthRequest authRequest = new FHAuthRequest(this.getContext());
        final AtomicBoolean success = new AtomicBoolean(false);
        FHActCallback callback = new FHActCallback(){

            public void success(FHResponse pResponse) {
                success.set(true);
            }

            public void fail(FHResponse pResponse) {
            }
        };
        authRequest.setPresentingActivity((Context)Mockito.mock(Context.class));
        BroadcastReceiver oauth2Receiver = (BroadcastReceiver)FHTestUtils.instanciatePrivateInnerClass("OAuthURLRedirectReceiver", authRequest, callback);
        oauth2Receiver.onReceive(null, new Intent().putExtra("url", "https://testing.feedhenry.me/box/srv/1.1/arm/authCallback?fh_auth_session=j6wnpwpb2xjn2a7quutrxubz&authResponse={\"authToken\":\"testToken\",\"email\":\"TestEmail\",\"family_name\":\"Henry\",\"gender\":\"male\",\"given_name\":\"Feed\",\"hd\":\"feedhenry.com\",\"id\":\"8675309\",\"link\":\"https://plus.google.com/8675309\",\"name\":\"Feed Henry\",\"picture\":\"http://www.feedhenry.com/wp-content/uploads/2015/01/fh-rh-top-logo-sm.png\",\"verified_email\":true}&status=complete&result=success#"));
        FHAuthRequestTest.assertTrue((boolean)success.get());
    }
}

