/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.api2;

import android.test.AndroidTestCase;
import com.feedhenry.sdk.FHActCallback;
import com.feedhenry.sdk.FHResponse;
import com.feedhenry.sdk.tests.sync.FHTestUtils;
import com.feedhenry.sdk2.FHHttpClient;
import com.feedhenry.sdk2.FHRemote;
import cz.msebera.android.httpclient.Header;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.json.fh.JSONObject;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FHRemoteTest
extends AndroidTestCase {
    private FHRemote fhRemote;

    protected void setUp() throws Exception {
        super.setUp();
        this.fhRemote = new FHRemote(this.getContext()){

            protected String getPath() {
                return "";
            }

            protected JSONObject getRequestArgs() {
                return new JSONObject();
            }

            protected Header[] buildHeaders(Header[] pHeaders) {
                return new Header[0];
            }
        };
    }

    public void testExecuteAsyncCallsHttpClientPost() throws Exception {
        FHHttpClient httpClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        FHTestUtils.injectInto(this.fhRemote, httpClient);
        FHActCallback callback = (FHActCallback)Mockito.mock(FHActCallback.class);
        this.fhRemote.execute(callback);
        ((FHHttpClient)Mockito.verify((Object)httpClient)).post((String)Matchers.eq((Object)"http://localhost:9000/box/srv/1.1/"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject()), (FHActCallback)Matchers.eq((Object)callback), Matchers.eq((boolean)false));
    }

    public void testExecuteAsyncWithSetCallbackCallsHttpClientPost() throws Exception {
        FHHttpClient httpClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        FHTestUtils.injectInto(this.fhRemote, httpClient);
        FHActCallback callback = (FHActCallback)Mockito.mock(FHActCallback.class);
        this.fhRemote.setCallback(callback);
        this.fhRemote.execute();
        ((FHHttpClient)Mockito.verify((Object)httpClient)).post((String)Matchers.eq((Object)"http://localhost:9000/box/srv/1.1/"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject()), (FHActCallback)Matchers.eq((Object)callback), Matchers.eq((boolean)false));
    }

    public void testExecuteThrowsExceptionThrownByHttpClient() throws Exception {
        FHHttpClient httpClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        FHTestUtils.injectInto(this.fhRemote, httpClient);
        final RuntimeException stubException = new RuntimeException("stubException");
        FHActCallback callback = (FHActCallback)Mockito.mock(FHActCallback.class);
        ((FHHttpClient)Mockito.doThrow((Throwable)stubException).when((Object)httpClient)).post((String)Matchers.eq((Object)"http://localhost:9000/box/srv/1.1/"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject()), (FHActCallback)Matchers.eq((Object)callback), Matchers.eq((boolean)false));
        this.fhRemote.setCallback(callback);
        this.fhRemote.execute();
        ((FHActCallback)Mockito.verify((Object)callback)).fail((FHResponse)Matchers.argThat((Matcher)new BaseMatcher<FHResponse>(){

            public boolean matches(Object item) {
                FHResponse resp = (FHResponse)item;
                if (resp.getArray() != null && resp.getArray().length() > 0) {
                    return false;
                }
                if (resp.getJson() != null && resp.getJson().length() > 0) {
                    return false;
                }
                return resp.getErrorMessage() != null && resp.getError().equals(stubException);
            }

            public void describeTo(Description description) {
            }
        }));
    }

    public void testExecuteThrowsException2ThrownByHttpClient() throws Exception {
        FHHttpClient httpClient = (FHHttpClient)Mockito.mock(FHHttpClient.class);
        FHTestUtils.injectInto(this.fhRemote, httpClient);
        final RuntimeException stubException = new RuntimeException("stubException");
        FHActCallback callback = (FHActCallback)Mockito.mock(FHActCallback.class);
        ((FHHttpClient)Mockito.doThrow((Throwable)stubException).when((Object)httpClient)).post((String)Matchers.eq((Object)"http://localhost:9000/box/srv/1.1/"), (Header[])Matchers.any(Header[].class), (JSONObject)Matchers.eq((Object)new JSONObject()), (FHActCallback)Matchers.eq((Object)callback), Matchers.eq((boolean)false));
        this.fhRemote.execute(callback);
        ((FHActCallback)Mockito.verify((Object)callback)).fail((FHResponse)Matchers.argThat((Matcher)new BaseMatcher<FHResponse>(){

            public boolean matches(Object item) {
                FHResponse resp = (FHResponse)item;
                if (resp.getArray() != null && resp.getArray().length() > 0) {
                    return false;
                }
                if (resp.getJson() != null && resp.getJson().length() > 0) {
                    return false;
                }
                return resp.getErrorMessage() != null && resp.getError().equals(stubException);
            }

            public void describeTo(Description description) {
            }
        }));
    }
}

