/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.sync;

import android.content.Context;
import android.test.AndroidTestCase;
import com.feedhenry.sdk.FH;
import com.feedhenry.sdk.sync.FHSyncClient;
import com.feedhenry.sdk.sync.FHSyncConfig;
import com.feedhenry.sdk.sync.FHSyncListener;
import com.feedhenry.sdk.sync.NotificationMessage;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

public class FHSyncClientTest
extends AndroidTestCase {
    private MockWebServer mockWebServer = null;

    public void setUp() throws Exception {
        super.setUp();
        this.mockWebServer = new MockWebServer();
        this.mockWebServer.start(9000);
        FH.init((Context)this.getContext(), null);
        FH.setLogLevel((int)1);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.mockWebServer.shutdown();
            Thread.sleep(100L);
        }
        catch (IOException | AssertionError | InterruptedException object) {
            // empty catch block
        }
        FH.stop();
    }

    public void testInitDestroyInitDestroyDoesNotThrowNPE() throws Exception {
        FHSyncClient client = FHSyncClient.getInstance();
        CountDownLatch latch = new CountDownLatch(1);
        client.init(this.getContext(), new FHSyncConfig(), (FHSyncListener)new LockingSyncListener(latch));
        client.destroy();
        latch = new CountDownLatch(1);
        client.init(this.getContext(), new FHSyncConfig(), (FHSyncListener)new LockingSyncListener(latch));
        client.destroy();
    }

    private static class LockingSyncListener
    implements FHSyncListener {
        final CountDownLatch latch;

        public LockingSyncListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onSyncStarted(NotificationMessage pMessage) {
            this.latch.countDown();
        }

        public void onSyncCompleted(NotificationMessage pMessage) {
        }

        public void onUpdateOffline(NotificationMessage pMessage) {
        }

        public void onCollisionDetected(NotificationMessage pMessage) {
        }

        public void onRemoteUpdateFailed(NotificationMessage pMessage) {
        }

        public void onRemoteUpdateApplied(NotificationMessage pMessage) {
        }

        public void onLocalUpdateApplied(NotificationMessage pMessage) {
        }

        public void onDeltaReceived(NotificationMessage pMessage) {
        }

        public void onSyncFailed(NotificationMessage pMessage) {
        }

        public void onClientStorageFailed(NotificationMessage pMessage) {
        }
    }
}

