/*
 * Decompiled with CFR 0.152.
 */
package com.feedhenry.sdk.tests.sync;

import com.feedhenry.sdk.sync.FHSyncUtils;
import junit.framework.TestCase;
import org.json.fh.JSONArray;
import org.json.fh.JSONObject;

public class FHSyncUtilsTest
extends TestCase {
    public void setUp() {
    }

    public void tearDown() {
    }

    public void testStringHash() throws Exception {
        String text = "test";
        String hashed = FHSyncUtils.generateHash((String)text);
        String expeted = "a94a8fe5ccb19ba61c4c0873d391e987982fbbd3";
        System.out.println("hashed = " + hashed);
        FHSyncUtilsTest.assertEquals((String)expeted, (String)hashed);
    }

    public void testGenerateObjHash() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("testKey", (Object)"Test Data");
        obj.put("testBoolKey", true);
        obj.put("testNumKey", 10);
        JSONArray arr = new JSONArray();
        arr.put((Object)"obj1");
        arr.put((Object)"obj2");
        obj.put("testArrayKey", (Object)arr);
        JSONObject jsobj = new JSONObject();
        jsobj.put("obj3key", (Object)"obj3");
        jsobj.put("obj4key", (Object)"obj4");
        obj.put("testDictKey", (Object)jsobj);
        String hash = FHSyncUtils.generateObjectHash((JSONObject)obj);
        System.out.println("Generated hash = " + hash);
        String expected = "5f4675723d658919ede35fac62fade8c6397df1d";
        FHSyncUtilsTest.assertEquals((String)expected, (String)hash);
    }
}

