/*
 * Decompiled with CFR 0.152.
 */
package com.geirsson.junit;

import com.geirsson.junit.EventDispatcher;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public final class TestFilter
extends Filter {
    private static final String DELIMITER = "\\,";
    private final HashSet<String> ignored = new HashSet();
    private final String[] testPatterns;
    private final EventDispatcher ed;

    public TestFilter(String string, EventDispatcher eventDispatcher) {
        this.ed = eventDispatcher;
        this.testPatterns = string.split(DELIMITER);
    }

    public String describe() {
        return "Filters out all tests not explicitly named in the '-tests=' option.";
    }

    public boolean shouldRun(Description description) {
        String string = description.getDisplayName();
        if (string.indexOf(40) == -1) {
            return true;
        }
        String string2 = string.substring(0, string.indexOf(40));
        if (this.ignored.contains(string2)) {
            return false;
        }
        for (String string3 : this.testPatterns) {
            if (!Pattern.matches(string3, string2)) continue;
            return true;
        }
        this.ignored.add(string2);
        this.ed.testIgnored(description);
        return false;
    }
}

