/*
 * Decompiled with CFR 0.152.
 */
package com.gkatzioura.maven.cloud.s3.plugin.upload;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.gkatzioura.maven.cloud.s3.EndpointProperty;
import com.gkatzioura.maven.cloud.s3.PathStyleEnabledProperty;
import com.gkatzioura.maven.cloud.s3.utils.S3Connect;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.authentication.AuthenticationException;

@Mojo(name="s3-upload")
public class S3UploadMojo
extends AbstractMojo {
    @Parameter(property="s3-upload.bucket")
    private String bucket;
    @Parameter(property="s3-upload.path")
    private String path;
    @Parameter(property="s3-upload.key")
    private String key;
    @Parameter(property="s3-upload.region")
    private String region;

    public S3UploadMojo() {
    }

    public S3UploadMojo(String bucket, String path, String key, String region) {
        this.bucket = bucket;
        this.path = path;
        this.key = key;
        this.region = region;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AmazonS3 amazonS3;
        if (this.bucket == null) {
            throw new MojoExecutionException("You need to specify a bucket for the s3-upload goal configuration");
        }
        try {
            amazonS3 = S3Connect.connect(null, this.region, EndpointProperty.empty(), new PathStyleEnabledProperty(String.valueOf(false)));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException(String.format("Unable to authenticate to S3 with the available credentials. Make sure to either define the environment variables or System properties defined in https://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/auth/DefaultAWSCredentialsProviderChain.html.%nDetail: %s", e.getMessage()), (Exception)((Object)e));
        }
        if (this.isDirectory()) {
            List<String> filesToUpload = this.findFilesToUpload(this.path);
            for (String fileToUpload : filesToUpload) {
                this.keyUpload(amazonS3, this.generateKeyName(fileToUpload), new File(fileToUpload));
            }
        } else {
            this.keyUpload(amazonS3, this.keyIfNull(), new File(this.path));
        }
    }

    private void keyUpload(AmazonS3 amazonS3, String keyName, File file) throws MojoExecutionException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength(file.length());
            PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucket, keyName, (InputStream)inputStream, objectMetadata);
            amazonS3.putObject(putObjectRequest);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to upload mojo", (Exception)e);
        }
    }

    private List<String> findFilesToUpload(String filePath) {
        ArrayList<String> totalFiles = new ArrayList<String>();
        File file = new File(filePath);
        if (file.isDirectory()) {
            File[] files;
            for (File lFile : files = file.listFiles()) {
                if (lFile.isDirectory()) {
                    List<String> filesFound = this.findFilesToUpload(lFile.getAbsolutePath());
                    totalFiles.addAll(filesFound);
                    continue;
                }
                totalFiles.add(lFile.getAbsolutePath());
            }
        } else {
            totalFiles.add(file.getAbsolutePath());
        }
        return totalFiles;
    }

    private boolean isDirectory() {
        return new File(this.path).isDirectory();
    }

    private String generateKeyName(String fullFilePath) {
        StringBuilder keyNameBuilder = new StringBuilder();
        String absolutePath = new File(this.path).getAbsolutePath();
        if (this.key != null) {
            keyNameBuilder.append(this.key);
            if (!fullFilePath.startsWith("/")) {
                keyNameBuilder.append("/");
            }
            keyNameBuilder.append(fullFilePath.replace(absolutePath, ""));
        } else {
            String clearFilePath = fullFilePath.replace(absolutePath, "");
            String filePathToAppend = clearFilePath.startsWith("/") ? clearFilePath.replaceFirst("/", "") : clearFilePath;
            keyNameBuilder.append(filePathToAppend);
        }
        return keyNameBuilder.toString();
    }

    private String keyIfNull() {
        if (this.key == null) {
            return new File(this.path).getName();
        }
        return this.key;
    }
}

