/*
 * Decompiled with CFR 0.152.
 */
package com.gkatzioura.maven.cloud.s3.utils;

import com.amazonaws.SdkClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.gkatzioura.maven.cloud.s3.CredentialsFactory;
import com.gkatzioura.maven.cloud.s3.EndpointProperty;
import com.gkatzioura.maven.cloud.s3.PathStyleEnabledProperty;
import com.gkatzioura.maven.cloud.s3.S3StorageRegionProviderChain;
import java.util.logging.Logger;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;

public class S3Connect {
    private static final Logger LOGGER = Logger.getLogger(S3Connect.class.getName());

    public static AmazonS3 connect(AuthenticationInfo authenticationInfo, String region, EndpointProperty endpoint, PathStyleEnabledProperty pathStyle) throws AuthenticationException {
        AmazonS3ClientBuilder builder = null;
        try {
            builder = S3Connect.createAmazonS3ClientBuilder(authenticationInfo, region, endpoint, pathStyle);
            AmazonS3 amazonS3 = (AmazonS3)builder.build();
            LOGGER.finer(String.format("Connected to S3 using bucket %s.", endpoint.get()));
            return amazonS3;
        }
        catch (SdkClientException e) {
            if (builder != null) {
                StringBuilder message = new StringBuilder();
                message.append("Failed to connect");
                if (builder.getEndpoint() != null) {
                    message.append(String.format(" to endpoint [%s] using region [%s]", builder.getEndpoint().getServiceEndpoint(), builder.getEndpoint().getSigningRegion()));
                } else {
                    message.append(String.format(" using region [%s]", builder.getRegion()));
                }
                throw new AuthenticationException(message.toString(), (Throwable)e);
            }
            throw new AuthenticationException("Could not authenticate", (Throwable)e);
        }
    }

    private static AmazonS3ClientBuilder createAmazonS3ClientBuilder(AuthenticationInfo authenticationInfo, String region, EndpointProperty endpoint, PathStyleEnabledProperty pathStyle) {
        S3StorageRegionProviderChain regionProvider = new S3StorageRegionProviderChain(region);
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(new CredentialsFactory().create(authenticationInfo));
        if (endpoint.isPresent()) {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint.get(), builder.getRegion()));
        } else {
            builder.setRegion(regionProvider.getRegion());
        }
        builder.setPathStyleAccessEnabled(Boolean.valueOf(pathStyle.get()));
        return builder;
    }
}

