/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.bag.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.bag.MutableBag;

/**
 * This file was automatically generated from template file mutablePrimitiveBag.stg.
 *
 * @since 3.0.
 */
public interface MutableLongBag extends MutableLongCollection, LongBag
{
    void addOccurrences(long item, int occurrences);

    boolean removeOccurrences(long item, int occurrences);

    MutableLongBag select(LongPredicate predicate);

    MutableLongBag reject(LongPredicate predicate);

    <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function);

    MutableLongBag with(long element);

    MutableLongBag without(long element);

    MutableLongBag withAll(LongIterable elements);

    MutableLongBag withoutAll(LongIterable elements);

    MutableLongBag asUnmodifiable();

    MutableLongBag asSynchronized();

    /**
     * Returns an immutable copy of this bag.
     */
    ImmutableLongBag toImmutable();
}
