/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.factory.map.primitive;

import com.gs.collections.api.map.primitive.ImmutableIntObjectMap;
import com.gs.collections.api.map.primitive.IntObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableIntObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableIntObjectMapFactory
{
    /**
     * Same as {@link #with()}.
     */
    <V> ImmutableIntObjectMap<V> of();

    <V> ImmutableIntObjectMap<V> with();

    /**
     * Same as {@link #with(int, Object)}.
     */
    <V> ImmutableIntObjectMap<V> of(int key, V value);

    <V> ImmutableIntObjectMap<V> with(int key, V value);

    /**
     * Same as {@link #withAll(IntObjectMap)}.
     */
    <V> ImmutableIntObjectMap<V> ofAll(IntObjectMap<? extends V>  map);

    <V> ImmutableIntObjectMap<V> withAll(IntObjectMap<? extends V>  map);
}
