/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatDoublePredicate;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;

/**
 * This file was automatically generated from template file immutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface ImmutableFloatDoubleMap extends FloatDoubleMap
{
    ImmutableFloatDoubleMap select(FloatDoublePredicate predicate);

    ImmutableFloatDoubleMap reject(FloatDoublePredicate predicate);

    ImmutableDoubleCollection select(DoublePredicate predicate);

    ImmutableDoubleCollection reject(DoublePredicate predicate);

    <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    ImmutableFloatDoubleMap newWithKeyValue(float key, double value);

    ImmutableFloatDoubleMap newWithoutKey(float key);

    ImmutableFloatDoubleMap newWithoutAllKeys(FloatIterable keys);
}
