/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.function.primitive.DoubleToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleLongPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableDoubleLongMap extends DoubleLongMap
{
    void clear();

    void put(double key, long value);

    void putAll(DoubleLongMap map);

    void removeKey(double key);

    void remove(double key);

    long removeKeyIfAbsent(double key, long value);

    long getIfAbsentPut(double key, long value);

    long getIfAbsentPut(double key, LongFunction0 function);

    long getIfAbsentPutWithKey(double key, DoubleToLongFunction function);

    <P> long getIfAbsentPutWith(double key, LongFunction<? super P> function, P parameter);

    long updateValue(double key, long initialValueIfAbsent, LongToLongFunction function);

    MutableDoubleLongMap select(DoubleLongPredicate predicate);

    MutableDoubleLongMap reject(DoubleLongPredicate predicate);

    MutableLongCollection select(LongPredicate predicate);

    MutableLongCollection reject(LongPredicate predicate);

    <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function);

    MutableDoubleLongMap withKeyValue(double key, long value);

    MutableDoubleLongMap withoutKey(double key);

    MutableDoubleLongMap withoutAllKeys(DoubleIterable keys);

    MutableDoubleLongMap asUnmodifiable();

    MutableDoubleLongMap asSynchronized();

    long addToValue(double key, long toBeAdded);
}
