/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.function.primitive.ShortToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.predicate.primitive.ShortDoublePredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortDoubleMap extends ShortDoubleMap
{
    void clear();

    void put(short key, double value);

    void putAll(ShortDoubleMap map);

    void removeKey(short key);

    void remove(short key);

    double removeKeyIfAbsent(short key, double value);

    double getIfAbsentPut(short key, double value);

    double getIfAbsentPut(short key, DoubleFunction0 function);

    double getIfAbsentPutWithKey(short key, ShortToDoubleFunction function);

    <P> double getIfAbsentPutWith(short key, DoubleFunction<? super P> function, P parameter);

    double updateValue(short key, double initialValueIfAbsent, DoubleToDoubleFunction function);

    MutableShortDoubleMap select(ShortDoublePredicate predicate);

    MutableShortDoubleMap reject(ShortDoublePredicate predicate);

    MutableDoubleCollection select(DoublePredicate predicate);

    MutableDoubleCollection reject(DoublePredicate predicate);

    <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function);

    MutableShortDoubleMap withKeyValue(short key, double value);

    MutableShortDoubleMap withoutKey(short key);

    MutableShortDoubleMap withoutAllKeys(ShortIterable keys);

    MutableShortDoubleMap asUnmodifiable();

    MutableShortDoubleMap asSynchronized();

    double addToValue(short key, double toBeAdded);
}
