/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.map.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ShortShortPredicate;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;

/**
 * This file was automatically generated from template file mutablePrimitivePrimitiveMap.stg.
 *
 * @since 3.0.
 */
public interface MutableShortShortMap extends ShortShortMap
{
    void clear();

    void put(short key, short value);

    void putAll(ShortShortMap map);

    void removeKey(short key);

    void remove(short key);

    short removeKeyIfAbsent(short key, short value);

    short getIfAbsentPut(short key, short value);

    short getIfAbsentPut(short key, ShortFunction0 function);

    short getIfAbsentPutWithKey(short key, ShortToShortFunction function);

    <P> short getIfAbsentPutWith(short key, ShortFunction<? super P> function, P parameter);

    short updateValue(short key, short initialValueIfAbsent, ShortToShortFunction function);

    MutableShortShortMap select(ShortShortPredicate predicate);

    MutableShortShortMap reject(ShortShortPredicate predicate);

    MutableShortCollection select(ShortPredicate predicate);

    MutableShortCollection reject(ShortPredicate predicate);

    <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function);

    MutableShortShortMap withKeyValue(short key, short value);

    MutableShortShortMap withoutKey(short key);

    MutableShortShortMap withoutAllKeys(ShortIterable keys);

    MutableShortShortMap asUnmodifiable();

    MutableShortShortMap asSynchronized();

    short addToValue(short key, short toBeAdded);
}
