/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.api.stack.primitive;

import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.stack.MutableStack;

/**
 * This file was automatically generated from template file mutablePrimitiveStack.stg.
 *
 * @since 3.0.
 */
public interface MutableCharStack extends CharStack
{
    /**
     * Adds an item to the top of the stack.
     */
    void push(char item);

    /**
     * Removes and returns the top element of the stack.
     */
    char pop();

    /**
     * Removes and returns a CharList of the number of elements specified by the count, beginning with the top of the stack.
     */
    CharList pop(int count);

    /**
     * Clears the Stack
     */
    void clear();

    MutableCharStack select(CharPredicate predicate);

    MutableCharStack reject(CharPredicate predicate);

    <V> MutableStack<V> collect(CharToObjectFunction<? extends V> function);

    MutableCharStack asUnmodifiable();

    MutableCharStack asSynchronized();
}
