/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.mutable;

import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.partition.bag.PartitionMutableBag;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.UnmodifiableBag;
import com.gs.collections.impl.collection.mutable.AbstractSynchronizedMutableCollection;
import com.gs.collections.impl.collection.mutable.SynchronizedCollectionSerializationProxy;
import com.gs.collections.impl.factory.Bags;
import java.io.Serializable;
import java.util.Collection;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedBag<T>
extends AbstractSynchronizedMutableCollection<T>
implements MutableBag<T>,
Serializable {
    SynchronizedBag(MutableBag<T> bag) {
        super(bag);
    }

    public SynchronizedBag(MutableBag<T> bag, Object newLock) {
        super(bag, newLock);
    }

    public static <E, B extends MutableBag<E>> SynchronizedBag<E> of(B bag) {
        return new SynchronizedBag(bag);
    }

    @GuardedBy(value="getLock()")
    private MutableBag<T> getMutableBag() {
        return (MutableBag)this.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return UnmodifiableBag.of(this);
        }
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        return Bags.immutable.ofAll((Iterable)((Object)this));
    }

    @Override
    public MutableBag<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntBag collectInt(IntFunction<? super T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().selectByOccurrences(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBag().addOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccurrences(Object item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().removeOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setOccurrences(T item, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().setOccurrences(item, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeDistinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().sizeDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int occurrencesOf(Object item) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().occurrencesOf(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableBag().forEachWithOccurrences(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapIterable<T, Integer> toMapOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().toMapOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableBag().zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringOfItemToCount() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableBag().toStringOfItemToCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        Object object = this.getLock();
        synchronized (object) {
            return (R)this.getMutableBag().zipWithIndex(target);
        }
    }

    @Override
    public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    protected Object writeReplace() {
        return new SynchronizedCollectionSerializationProxy<T>(this.getMutableBag());
    }
}

