/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.block.factory.primitive;

import com.gs.collections.api.block.predicate.primitive.LongPredicate;

public final class LongPredicates {
    private static final LongIsEvenPredicate IS_EVEN = new LongIsEvenPredicate();
    private static final LongIsOddPredicate IS_ODD = new LongIsOddPredicate();
    private static final LongPredicate ALWAYS_TRUE = new AlwaysTrueLongPredicate();
    private static final LongPredicate ALWAYS_FALSE = new AlwaysFalseLongPredicate();

    private LongPredicates() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LongPredicate equal(long expected) {
        return new EqualsLongPredicate(expected);
    }

    public static LongPredicate lessThan(long expected) {
        return new LessThanLongPredicate(expected);
    }

    public static LongPredicate greaterThan(long expected) {
        return new GreaterThanLongPredicate(expected);
    }

    public static LongPredicate isEven() {
        return IS_EVEN;
    }

    public static LongPredicate isOdd() {
        return IS_ODD;
    }

    public static LongPredicate alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static LongPredicate alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static LongPredicate and(LongPredicate one, LongPredicate two) {
        return new AndLongPredicate(one, two);
    }

    public static LongPredicate or(LongPredicate one, LongPredicate two) {
        return new OrLongPredicate(one, two);
    }

    public static LongPredicate not(LongPredicate negate) {
        return new NotLongPredicate(negate);
    }

    private static final class AlwaysFalseLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;

        private AlwaysFalseLongPredicate() {
        }

        public boolean accept(long value) {
            return false;
        }
    }

    private static final class AlwaysTrueLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;

        private AlwaysTrueLongPredicate() {
        }

        public boolean accept(long value) {
            return true;
        }
    }

    private static final class LongIsOddPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;

        private LongIsOddPredicate() {
        }

        public boolean accept(long integral) {
            return integral % 2L != 0L;
        }
    }

    private static final class LongIsEvenPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;

        private LongIsEvenPredicate() {
        }

        public boolean accept(long integral) {
            return integral % 2L == 0L;
        }
    }

    private static final class NotLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final LongPredicate negate;

        private NotLongPredicate(LongPredicate negate) {
            this.negate = negate;
        }

        public boolean accept(long actual) {
            return !this.negate.accept(actual);
        }
    }

    private static final class OrLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final LongPredicate one;
        private final LongPredicate two;

        private OrLongPredicate(LongPredicate one, LongPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(long actual) {
            return this.one.accept(actual) || this.two.accept(actual);
        }
    }

    private static final class AndLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final LongPredicate one;
        private final LongPredicate two;

        private AndLongPredicate(LongPredicate one, LongPredicate two) {
            this.one = one;
            this.two = two;
        }

        public boolean accept(long actual) {
            return this.one.accept(actual) && this.two.accept(actual);
        }
    }

    private static final class GreaterThanLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final long expected;

        private GreaterThanLongPredicate(long expected) {
            this.expected = expected;
        }

        public boolean accept(long actual) {
            return actual > this.expected;
        }
    }

    private static final class LessThanLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final long expected;

        private LessThanLongPredicate(long expected) {
            this.expected = expected;
        }

        public boolean accept(long actual) {
            return actual < this.expected;
        }
    }

    private static final class EqualsLongPredicate
    implements LongPredicate {
        private static final long serialVersionUID = 1L;
        private final long expected;

        private EqualsLongPredicate(long expected) {
            this.expected = expected;
        }

        public boolean accept(long actual) {
            return actual == this.expected;
        }
    }
}

