/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableIterator<T>
implements Iterator<T> {
    protected int currentIndex;
    protected final List<T> list;

    public ImmutableIterator(List<T> list) {
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex != this.list.size();
    }

    @Override
    public T next() {
        try {
            T result = this.list.get(this.currentIndex);
            ++this.currentIndex;
            return result;
        }
        catch (IndexOutOfBoundsException ignored) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }
}

