/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableLongListFactory;
import com.gs.collections.api.list.primitive.ImmutableLongList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableLongArrayList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableLongEmptyList;
import com.gs.collections.impl.list.immutable.primitive.ImmutableLongSingletonList;

public class ImmutableLongListFactoryImpl
implements ImmutableLongListFactory {
    public ImmutableLongList of() {
        return this.with();
    }

    public ImmutableLongList with() {
        return ImmutableLongEmptyList.INSTANCE;
    }

    public ImmutableLongList of(long one) {
        return this.with(one);
    }

    public ImmutableLongList with(long one) {
        return new ImmutableLongSingletonList(one);
    }

    public ImmutableLongList of(long ... items) {
        return this.with(items);
    }

    public ImmutableLongList with(long ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableLongArrayList.newListWith(items);
    }

    public ImmutableLongList ofAll(LongIterable items) {
        return this.withAll(items);
    }

    public ImmutableLongList withAll(LongIterable items) {
        if (items instanceof ImmutableLongList) {
            return (ImmutableLongList)items;
        }
        return this.with(items.toArray());
    }
}

