/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.CharFunction0;
import com.gs.collections.api.block.function.primitive.CharToCharFunction;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.LongToCharFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.LongCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongCharProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.ImmutableLongCharMap;
import com.gs.collections.api.map.primitive.LongCharMap;
import com.gs.collections.api.map.primitive.MutableLongCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.api.tuple.primitive.LongCharPair;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import com.gs.collections.impl.factory.primitive.LongCharMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedLongCharMap;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableLongCharMap
implements MutableLongCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableLongCharMap map;

    UnmodifiableLongCharMap(MutableLongCharMap map) {
        this.map = map;
    }

    private boolean isAbsent(char result, long key) {
        return result == '\u0000' && !this.containsKey(key);
    }

    private char getIfAbsentThrow(long key) {
        char result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(long key, char value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(LongCharMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(long key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(long key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public char removeKeyIfAbsent(long key, char value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public char getIfAbsentPut(long key, char value) {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPut(long key, CharFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public char getIfAbsentPutWithKey(long key, LongToCharFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> char getIfAbsentPutWith(long key, CharFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public char updateValue(long key, char initialValueIfAbsent, CharToCharFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public char get(long key) {
        return this.map.get(key);
    }

    public char getIfAbsent(long key, char ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(long key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(LongProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(LongCharProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyLongIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<LongCharPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableLongCharMap select(LongCharPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongCharMap reject(LongCharPredicate predicate) {
        return this.map.reject(predicate);
    }

    public CharIterator charIterator() {
        return this.map.charIterator();
    }

    public void forEach(CharProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate) {
        return this.map.reject(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public char max() {
        return this.map.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.map.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public char addToValue(long key, char toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public char[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.map.toSortedList();
    }

    public char[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(char value) {
        return this.map.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.map.containsAll(source);
    }

    public MutableCharList toList() {
        return this.map.toList();
    }

    public MutableCharSet toSet() {
        return this.map.toSet();
    }

    public MutableCharBag toBag() {
        return this.map.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableLongCharMap withKeyValue(long key, char value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableLongCharMap withoutKey(long key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableLongCharMap withoutAllKeys(LongIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableLongCharMap asUnmodifiable() {
        return this;
    }

    public MutableLongCharMap asSynchronized() {
        return new SynchronizedLongCharMap(this);
    }

    public ImmutableLongCharMap toImmutable() {
        return LongCharMaps.immutable.withAll((LongCharMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(this.map.keySet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }
}

