/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntHashSet
implements MutableIntSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int EMPTY = 0;
    private static final int REMOVED = 1;
    private int[] table;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private int zeroToThirtyOne;
    private int zeroToThirtyOneOccupied;
    private transient boolean copyOnWrite;

    public IntHashSet() {
        this.allocateTable(16);
    }

    public IntHashSet(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public IntHashSet(IntHashSet set) {
        this.occupiedWithData = set.occupiedWithData;
        this.occupiedWithSentinels = set.occupiedWithSentinels;
        this.zeroToThirtyOneOccupied = set.zeroToThirtyOneOccupied;
        this.zeroToThirtyOne = set.zeroToThirtyOne;
        this.allocateTable(set.table.length);
        System.arraycopy(set.table, 0, this.table, 0, set.table.length);
    }

    public static IntHashSet newSet(IntIterable source) {
        if (source instanceof IntHashSet) {
            return new IntHashSet((IntHashSet)source);
        }
        return IntHashSet.newSetWith(source.toArray());
    }

    public static IntHashSet newSetWith(int ... source) {
        IntHashSet result = new IntHashSet();
        result.addAll(source);
        return result;
    }

    private static boolean isBetweenZeroAndThirtyOne(int value) {
        return value >= 0 && value <= 31;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet other = (IntSet)obj;
        return this.size() == other.size() && this.containsAll(other.toArray());
    }

    public int hashCode() {
        int value;
        int result = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += value;
        }
        if (this.table != null) {
            for (int i = 0; i < this.table.length; ++i) {
                if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                result += this.table[i];
            }
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + this.zeroToThirtyOneOccupied;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            int value;
            appendable.append(start);
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value));
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(value2));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean add(int element) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(element)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne |= 1 << element;
            if (this.zeroToThirtyOne != initial) {
                ++this.zeroToThirtyOneOccupied;
                return true;
            }
            return false;
        }
        int index = this.probe(element);
        if (this.table[index] == element) {
            return false;
        }
        if (this.copyOnWrite) {
            this.copyTable();
        }
        if (this.table[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.table[index] = element;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return true;
    }

    public boolean addAll(int ... source) {
        int oldSize = this.size();
        for (int item : source) {
            this.add(item);
        }
        return this.size() != oldSize;
    }

    public boolean addAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof IntHashSet) {
            IntHashSet hashSet = (IntHashSet)source;
            this.zeroToThirtyOne |= hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (int item : hashSet.table) {
                if (!IntHashSet.isNonSentinel(item)) continue;
                this.add(item);
            }
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int item = iterator.next();
                this.add(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean remove(int value) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
            int initial = this.zeroToThirtyOne;
            this.zeroToThirtyOne &= ~(1 << value);
            if (this.zeroToThirtyOne == initial) {
                return false;
            }
            --this.zeroToThirtyOneOccupied;
            return true;
        }
        int index = this.probe(value);
        if (this.table[index] == value) {
            if (this.copyOnWrite) {
                this.copyTable();
            }
            this.table[index] = 1;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    public boolean removeAll(IntIterable source) {
        if (source.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        if (source instanceof IntHashSet) {
            IntHashSet hashSet = (IntHashSet)source;
            this.zeroToThirtyOne &= ~hashSet.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = Integer.bitCount(this.zeroToThirtyOne);
            for (int item : hashSet.table) {
                if (!IntHashSet.isNonSentinel(item)) continue;
                this.remove(item);
            }
        } else {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                int item = iterator.next();
                this.remove(item);
            }
        }
        return this.size() != oldSize;
    }

    public boolean removeAll(int ... source) {
        if (source.length == 0) {
            return false;
        }
        int oldSize = this.size();
        for (int item : source) {
            this.remove(item);
        }
        return this.size() != oldSize;
    }

    public boolean retainAll(IntIterable source) {
        int oldSize = this.size();
        Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
        IntHashSet retained = this.select(new IntPredicate((IntSet)sourceSet){
            final /* synthetic */ IntSet val$sourceSet;
            {
                this.val$sourceSet = intSet;
            }

            public boolean accept(int value) {
                return this.val$sourceSet.contains(value);
            }
        });
        if (retained.size() != oldSize) {
            this.zeroToThirtyOne = retained.zeroToThirtyOne;
            this.zeroToThirtyOneOccupied = retained.zeroToThirtyOneOccupied;
            this.occupiedWithData = retained.occupiedWithData;
            this.occupiedWithSentinels = retained.occupiedWithSentinels;
            this.table = retained.table;
            return true;
        }
        return false;
    }

    public boolean retainAll(int ... source) {
        return this.retainAll((IntIterable)IntHashSet.newSetWith(source));
    }

    public void clear() {
        this.zeroToThirtyOneOccupied = 0;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        this.zeroToThirtyOne = 0;
        if (this.copyOnWrite) {
            this.table = new int[this.table.length];
            this.copyOnWrite = false;
        } else {
            Arrays.fill(this.table, 0);
        }
    }

    public IntHashSet with(int element) {
        this.add(element);
        return this;
    }

    public IntHashSet without(int element) {
        this.remove(element);
        return this;
    }

    public IntHashSet withAll(IntIterable elements) {
        this.addAll(elements.toArray());
        return this;
    }

    public IntHashSet withoutAll(IntIterable elements) {
        this.removeAll(elements);
        return this;
    }

    public MutableIntSet asUnmodifiable() {
        return new UnmodifiableIntSet(this);
    }

    public MutableIntSet asSynchronized() {
        return new SynchronizedIntSet(this);
    }

    public ImmutableIntSet toImmutable() {
        if (this.size() == 0) {
            return IntSets.immutable.with();
        }
        if (this.size() == 1) {
            return IntSets.immutable.with(this.intIterator().next());
        }
        IntHashSet mutableSet = IntHashSet.newSetWith(this.toArray());
        return new ImmutableIntHashSet(mutableSet.table, mutableSet.occupiedWithData, mutableSet.zeroToThirtyOne, mutableSet.zeroToThirtyOneOccupied);
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int value;
        int[] array = new int[this.size()];
        int j = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            array[j] = value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            ++j;
        }
        for (int i = 0; i < this.table.length && j < this.size(); ++i) {
            if (!IntHashSet.isNonSentinel(this.table[i])) continue;
            array[j] = this.table[i];
            ++j;
        }
        return array;
    }

    public boolean contains(int value) {
        if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
            int temp = this.zeroToThirtyOne;
            return (temp >>> value & 1) != 0;
        }
        return this.table[this.probe(value)] == value;
    }

    public boolean containsAll(int ... source) {
        for (int item : source) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public void forEach(IntProcedure procedure) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            procedure.value(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            procedure.value(value2);
        }
    }

    public IntHashSet select(IntPredicate predicate) {
        int value;
        IntHashSet result = new IntHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            result.add(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public MutableIntSet reject(IntPredicate predicate) {
        int value;
        IntHashSet result = new IntHashSet();
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            result.add(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            result.add(value2);
        }
        return result;
    }

    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        int value;
        UnifiedSet target = UnifiedSet.newSet(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            target.add(function.valueOf(value));
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            target.add(function.valueOf(value2));
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return value;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return value2;
        }
        return ifNone;
    }

    public int count(IntPredicate predicate) {
        int value;
        int count = 0;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            ++count;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return true;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (predicate.accept(value)) continue;
            return false;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        int value;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            if (!predicate.accept(value)) continue;
            return false;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public long sum() {
        int value;
        long result = 0L;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result += (long)value;
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            result += (long)value2;
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
        boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
        for (int value : this.table) {
            if (!IntHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
            max = value;
            isMaxSet = true;
        }
        return max;
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
        boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
        for (int value : this.table) {
            if (!IntHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
            min = value;
            isMinSet = true;
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public IntSet freeze() {
        if (this.size() == 0) {
            return IntSets.immutable.with();
        }
        if (this.size() == 1) {
            return IntSets.immutable.with(this.intIterator().next());
        }
        this.copyOnWrite = true;
        return new ImmutableIntHashSet(this.table, this.occupiedWithData, this.zeroToThirtyOne, this.zeroToThirtyOneOccupied);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int value;
        out.writeInt(this.size());
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            out.writeInt(value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            out.writeInt(value2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(in.readInt());
        }
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        int value;
        Object result = injectedValue;
        for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
            value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
            result = function.valueOf(result, value);
        }
        for (int value2 : this.table) {
            if (!IntHashSet.isNonSentinel(value2)) continue;
            result = function.valueOf(result, value2);
        }
        return result;
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.table.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.table.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.table.length;
        int[] old = this.table;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntHashSet.isNonSentinel(old[i])) continue;
            this.add(old[i]);
        }
    }

    private void allocateTable(int sizeToAllocate) {
        this.table = new int[sizeToAllocate];
    }

    int probe(int element) {
        int index = this.spread(element);
        int valueAtIndex = this.table[index];
        if (valueAtIndex == element || valueAtIndex == 0) {
            return index;
        }
        int removedIndex = valueAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex = nextIndex + probe & this.table.length - 1;
            probe += 17;
            if (this.table[nextIndex] == element) {
                return nextIndex;
            }
            if (this.table[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.table[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.table.length - 1;
    }

    private void copyTable() {
        this.copyOnWrite = false;
        int[] copy = new int[this.table.length];
        System.arraycopy(this.table, 0, copy, 0, Math.min(this.table.length, this.table.length));
        this.table = copy;
    }

    private int maxOccupiedWithData() {
        int capacity = this.table.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.table.length / 4;
    }

    private static boolean isNonSentinel(int value) {
        return value != 0 && value != 1;
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private int zeroToThirtyOne;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < IntHashSet.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            while (this.zeroToThirtyOne < 32) {
                if (IntHashSet.this.contains(this.zeroToThirtyOne)) {
                    int result = this.zeroToThirtyOne++;
                    return result;
                }
                ++this.zeroToThirtyOne;
            }
            int[] table = IntHashSet.this.table;
            while (!IntHashSet.isNonSentinel(table[this.position])) {
                ++this.position;
            }
            int result = table[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableIntHashSet
    implements ImmutableIntSet,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int[] table;
        private final int occupied;
        private final int zeroToThirtyOne;
        private final int zeroToThirtyOneOccupied;

        private ImmutableIntHashSet(int[] table, int occupied, int zeroToThirtyOne, int zeroToThirtyOneOccupied) {
            this.checkOptimizedSize(occupied + zeroToThirtyOneOccupied);
            this.occupied = occupied;
            this.zeroToThirtyOneOccupied = zeroToThirtyOneOccupied;
            this.zeroToThirtyOne = zeroToThirtyOne;
            this.table = table;
        }

        private void checkOptimizedSize(int length) {
            if (length <= 1) {
                throw new IllegalArgumentException("Use IntSets.immutable.with() to instantiate an optimized collection");
            }
        }

        public static ImmutableIntSet newSetWith(int ... elements) {
            return IntHashSet.newSetWith(elements).toImmutable();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntSet)) {
                return false;
            }
            IntSet other = (IntSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int value;
            int result = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += value;
            }
            if (this.table != null) {
                for (int i = 0; i < this.table.length; ++i) {
                    if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                    result += this.table[i];
                }
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public ImmutableIntSet newWith(int element) {
            return IntHashSet.newSet((IntIterable)this).with(element).toImmutable();
        }

        public ImmutableIntSet newWithout(int element) {
            return IntHashSet.newSet((IntIterable)this).without(element).toImmutable();
        }

        public ImmutableIntSet newWithAll(IntIterable elements) {
            return IntHashSet.newSet((IntIterable)this).withAll(elements).toImmutable();
        }

        public ImmutableIntSet newWithoutAll(IntIterable elements) {
            return IntHashSet.newSet((IntIterable)this).withoutAll(elements).toImmutable();
        }

        public int size() {
            return this.occupied + this.zeroToThirtyOneOccupied;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean notEmpty() {
            return this.size() != 0;
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                int value;
                appendable.append(start);
                int count = 0;
                for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                    value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value));
                }
                for (int value2 : this.table) {
                    if (!IntHashSet.isNonSentinel(value2)) continue;
                    if (count > 0) {
                        appendable.append(separator);
                    }
                    ++count;
                    appendable.append(String.valueOf(value2));
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return new InternalIntIterator();
        }

        public int[] toArray() {
            int value;
            int[] array = new int[this.size()];
            int j = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                array[j] = value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                ++j;
            }
            for (int i = 0; i < this.table.length && j < this.size(); ++i) {
                if (!IntHashSet.isNonSentinel(this.table[i])) continue;
                array[j] = this.table[i];
                ++j;
            }
            return array;
        }

        public boolean contains(int value) {
            if (IntHashSet.isBetweenZeroAndThirtyOne(value)) {
                int temp = this.zeroToThirtyOne;
                return (temp >>> value & 1) != 0;
            }
            return this.table[this.probe(value)] == value;
        }

        public boolean containsAll(int ... source) {
            for (int item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public void forEach(IntProcedure procedure) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                procedure.value(value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                procedure.value(value2);
            }
        }

        public ImmutableIntSet select(IntPredicate predicate) {
            int value;
            IntHashSet result = new IntHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                result.add(value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public ImmutableIntSet reject(IntPredicate predicate) {
            int value;
            IntHashSet result = new IntHashSet();
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                result.add(value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                result.add(value2);
            }
            return result.toImmutable();
        }

        public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            int value;
            UnifiedSet target = UnifiedSet.newSet(this.size());
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                target.add(function.valueOf(value));
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                target.add(function.valueOf(value2));
            }
            return target.toImmutable();
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return value;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return value2;
            }
            return ifNone;
        }

        public int count(IntPredicate predicate) {
            int value;
            int count = 0;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                ++count;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return true;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (predicate.accept(value)) continue;
                return false;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            int value;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                if (!predicate.accept(value)) continue;
                return false;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2) || !predicate.accept(value2)) continue;
                return false;
            }
            return true;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public long sum() {
            int value;
            long result = 0L;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result += (long)value;
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                result += (long)value2;
            }
            return result;
        }

        public int max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 31 - Integer.numberOfLeadingZeros(this.zeroToThirtyOne);
            boolean isMaxSet = this.zeroToThirtyOneOccupied != 0;
            for (int value : this.table) {
                if (!IntHashSet.isNonSentinel(value) || isMaxSet && max >= value) continue;
                max = value;
                isMaxSet = true;
            }
            return max;
        }

        public int maxIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public int min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = Integer.numberOfTrailingZeros(this.zeroToThirtyOne);
            boolean isMinSet = this.zeroToThirtyOneOccupied != 0;
            for (int value : this.table) {
                if (!IntHashSet.isNonSentinel(value) || isMinSet && value >= min) continue;
                min = value;
                isMinSet = true;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            int value;
            Object result = injectedValue;
            for (int zeroToThirtyOne = this.zeroToThirtyOne; zeroToThirtyOne != 0; zeroToThirtyOne &= ~(1 << value)) {
                value = Integer.numberOfTrailingZeros(zeroToThirtyOne);
                result = function.valueOf(result, value);
            }
            for (int value2 : this.table) {
                if (!IntHashSet.isNonSentinel(value2)) continue;
                result = function.valueOf(result, value2);
            }
            return result;
        }

        public IntSet freeze() {
            return this;
        }

        public ImmutableIntSet toImmutable() {
            return this;
        }

        private Object writeReplace() {
            return new ImmutableIntSetSerializationProxy((IntSet)this);
        }

        int probe(int element) {
            int index = this.spread(element);
            int valueAtIndex = this.table[index];
            if (valueAtIndex == element || valueAtIndex == 0) {
                return index;
            }
            int removedIndex = valueAtIndex == 1 ? index : -1;
            int nextIndex = index;
            int probe = 17;
            while (true) {
                nextIndex = nextIndex + probe & this.table.length - 1;
                probe += 17;
                if (this.table[nextIndex] == element) {
                    return nextIndex;
                }
                if (this.table[nextIndex] == 1) {
                    if (removedIndex != -1) continue;
                    removedIndex = nextIndex;
                    continue;
                }
                if (this.table[nextIndex] == 0) break;
            }
            return removedIndex == -1 ? nextIndex : removedIndex;
        }

        int spread(int element) {
            int code = element;
            code ^= 0x3D ^ code >> 16;
            code += code << 3;
            code ^= code >> 4;
            code *= 668265261;
            code ^= code >> 15;
            return code & this.table.length - 1;
        }

        private class InternalIntIterator
        implements IntIterator {
            private int count;
            private int position;
            private int zeroToThirtyOne;

            private InternalIntIterator() {
            }

            public boolean hasNext() {
                return this.count < ImmutableIntHashSet.this.size();
            }

            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                while (this.zeroToThirtyOne < 32) {
                    if (ImmutableIntHashSet.this.contains(this.zeroToThirtyOne)) {
                        int result = this.zeroToThirtyOne++;
                        return result;
                    }
                    ++this.zeroToThirtyOne;
                }
                int[] table = ImmutableIntHashSet.this.table;
                while (!IntHashSet.isNonSentinel(table[this.position])) {
                    ++this.position;
                }
                int result = table[this.position];
                ++this.position;
                return result;
            }
        }
    }
}

