/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.result.Row;
import org.h2.store.Data;
import org.h2.store.Page;

abstract class PageData
extends Page {
    static final int ROOT = 0;
    static final int UNKNOWN_ROWCOUNT = -1;
    protected final PageScanIndex index;
    protected int parentPageId;
    protected final Data data;
    protected int entryCount;
    protected int[] keys;
    protected boolean written;

    PageData(PageScanIndex pageScanIndex, int n, Data data) {
        this.index = pageScanIndex;
        this.data = data;
        this.setPos(n);
    }

    abstract int getRowCount() throws SQLException;

    abstract void setRowCountStored(int var1) throws SQLException;

    int find(int n) {
        int n2 = 0;
        int n3 = this.entryCount;
        while (n2 < n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.keys[n4];
            if (n5 == n) {
                return n4;
            }
            if (n5 > n) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    abstract int addRowTry(Row var1) throws SQLException;

    abstract Cursor find(Session var1) throws SQLException;

    int getKey(int n) {
        return this.keys[n];
    }

    abstract PageData split(int var1) throws SQLException;

    void setPageId(int n) throws SQLException {
        this.written = false;
        this.index.getPageStore().removeRecord(this.getPos());
        this.setPos(n);
        this.remapChildren();
    }

    abstract int getLastKey() throws SQLException;

    abstract PageDataLeaf getFirstLeaf() throws SQLException;

    void setParentPageId(int n) {
        this.written = false;
        this.parentPageId = n;
    }

    abstract void remapChildren() throws SQLException;

    abstract boolean remove(int var1) throws SQLException;

    abstract void freeChildren() throws SQLException;

    abstract Row getRow(int var1) throws SQLException;

    public int getMemorySize() {
        return this.index.getPageStore().getPageSize() >> 1;
    }

    int getParentPageId() {
        return this.parentPageId;
    }
}

