/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.PageDataLeaf;
import org.h2.index.PageScanIndex;
import org.h2.message.Message;
import org.h2.store.Data;
import org.h2.store.DataPage;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageDataOverflow
extends Page {
    static final int START_LAST = 11;
    static final int START_MORE = 13;
    private static final int START_NEXT_OVERFLOW = 9;
    private final PageScanIndex index;
    private int type;
    private int parentPage;
    private int nextPage;
    private int size;
    private Data data;

    PageDataOverflow(PageScanIndex pageScanIndex, int n, int n2, int n3, int n4, Data data, int n5, int n6) {
        this.index = pageScanIndex;
        this.setPos(n);
        this.type = n2;
        this.parentPage = n3;
        this.nextPage = n4;
        this.size = n6;
        this.data = pageScanIndex.getPageStore().createData();
        this.data.writeInt(this.parentPage);
        this.data.writeByte((byte)n2);
        this.data.writeInt(pageScanIndex.getId());
        if (n2 == 3) {
            this.data.writeInt(this.nextPage);
        } else {
            this.data.writeShortInt(n6);
        }
        this.data.write(data.getBytes(), n5, n6);
    }

    PageDataOverflow(PageScanIndex pageScanIndex, int n, Data data) {
        this.index = pageScanIndex;
        this.setPos(n);
        this.data = data;
    }

    public static Page read(PageScanIndex pageScanIndex, Data data, int n) throws SQLException {
        PageDataOverflow pageDataOverflow = new PageDataOverflow(pageScanIndex, n, data);
        pageDataOverflow.read();
        return pageDataOverflow;
    }

    private void read() throws SQLException {
        this.data.reset();
        this.parentPage = this.data.readInt();
        this.type = this.data.readByte();
        int n = this.data.readInt();
        if (n != this.index.getId()) {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + " got:" + n + " type:" + this.type);
        }
        if (this.type == 19) {
            this.size = this.data.readShortInt();
            this.nextPage = 0;
        } else if (this.type == 3) {
            this.size = this.index.getPageStore().getPageSize() - 13;
            this.nextPage = this.data.readInt();
        } else {
            throw Message.getSQLException(90030, "page:" + this.getPos() + " type:" + this.type);
        }
    }

    int readInto(Data data) {
        data.checkCapacity(this.size);
        if (this.type == 19) {
            data.write(this.data.getBytes(), 11, this.size);
            return 0;
        }
        data.write(this.data.getBytes(), 13, this.size);
        return this.nextPage;
    }

    int getNextOverflow() {
        return this.nextPage;
    }

    public int getByteCount(DataPage dataPage) {
        return this.index.getPageStore().getPageSize();
    }

    public void write(DataPage dataPage) throws SQLException {
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    public String toString() {
        return "page[" + this.getPos() + "] data leaf overflow parent:" + this.parentPage + " next:" + this.nextPage;
    }

    public int getMemorySize() {
        return this.index.getPageStore().getPageSize() >> 1;
    }

    void setParentPageId(int n) {
        this.parentPage = n;
    }

    public void moveTo(Session session, int n) throws SQLException {
        Page page;
        PageStore pageStore = this.index.getPageStore();
        int n2 = this.type == 3 ? 13 : 11;
        PageDataOverflow pageDataOverflow = new PageDataOverflow(this.index, n, this.type, this.parentPage, this.nextPage, this.data, n2, this.size);
        pageStore.updateRecord(pageDataOverflow, false, null);
        if (this.nextPage != 0) {
            page = (PageDataOverflow)pageStore.getPage(this.nextPage);
            ((PageDataOverflow)page).setParentPageId(n);
        }
        if ((page = pageStore.getPage(this.parentPage)) == null) {
            throw Message.throwInternalError();
        }
        if (page instanceof PageDataOverflow) {
            PageDataOverflow pageDataOverflow2 = (PageDataOverflow)page;
            pageDataOverflow2.setOverflow(n);
        } else {
            PageDataLeaf pageDataLeaf = (PageDataLeaf)page;
            pageDataLeaf.setOverflow(n);
        }
        pageStore.freePage(this.getPos(), true, this.data);
    }

    private void setOverflow(int n) throws SQLException {
        this.nextPage = n;
        this.data.setInt(9, n);
        this.index.getPageStore().updateRecord(this, true, this.data);
    }
}

