/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.store.PageStore;
import org.h2.store.PageStreamData;
import org.h2.store.PageStreamTrunk;
import org.h2.util.BitField;
import org.h2.util.IntArray;

public class PageOutputStream
extends OutputStream {
    private PageStore store;
    private final Trace trace;
    private int trunkPageId;
    private final BitField exclude;
    private int trunkNext;
    private IntArray reservedPages = new IntArray();
    private PageStreamTrunk trunk;
    private PageStreamData data;
    private int reserved;
    private int remaining;
    private byte[] buffer = new byte[1];
    private boolean needFlush;
    private boolean writing;
    private int pages;
    private boolean atEnd;

    public PageOutputStream(PageStore pageStore, int n, BitField bitField, boolean bl) {
        this.trace = pageStore.getTrace();
        this.store = pageStore;
        this.trunkPageId = n;
        this.exclude = bitField;
        this.atEnd = bl;
    }

    void reserve(int n) throws SQLException {
        if (this.reserved < n) {
            int n2;
            int n3;
            int n4 = this.store.getPageSize();
            int n5 = PageStreamData.getCapacity(n4);
            int n6 = n3 = PageStreamTrunk.getPagesAddressed(n4);
            for (n2 = n3 * n5; n2 < n; n2 += n2) {
                n6 += n6;
            }
            int n7 = this.atEnd ? this.trunkPageId : 0;
            this.store.allocatePages(this.reservedPages, ++n6, this.exclude, n7);
            this.reserved += n2;
            if (this.data == null) {
                this.initNextData();
            }
        }
    }

    public void write(int n) throws IOException {
        this.buffer[0] = (byte)n;
        this.write(this.buffer);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    private void initNextData() throws SQLException {
        int n;
        int n2 = n = this.trunk == null ? -1 : this.trunk.getNextPageData();
        if (n == -1) {
            int n3 = this.trunkPageId;
            if (this.trunkNext != 0) {
                this.trunkPageId = this.trunkNext;
            }
            int n4 = PageStreamTrunk.getPagesAddressed(this.store.getPageSize());
            int[] nArray = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray[i] = this.reservedPages.get(i);
            }
            this.trunkNext = this.reservedPages.get(n4);
            this.trunk = PageStreamTrunk.create(this.store, n3, this.trunkPageId, this.trunkNext, nArray);
            ++this.pages;
            this.trunk.write(null);
            this.reservedPages.removeRange(0, n4 + 1);
            n = this.trunk.getNextPageData();
        }
        this.data = PageStreamData.create(this.store, n, this.trunk.getPos());
        ++this.pages;
        this.data.initWrite();
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.writing) {
            Message.throwInternalError("writing while still writing");
        }
        try {
            this.reserve(n2);
            this.writing = true;
            while (n2 > 0) {
                int n3 = this.data.write(byArray, n, n2);
                if (n3 < n2) {
                    this.storePage();
                    this.initNextData();
                }
                this.reserved -= n3;
                n += n3;
                n2 -= n3;
            }
            this.needFlush = true;
            this.remaining -= n2;
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
        finally {
            this.writing = false;
        }
    }

    private void storePage() throws IOException {
        try {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("pageOut.storePage " + this.data.getPos());
            }
            this.data.write(null);
        }
        catch (SQLException sQLException) {
            throw Message.convertToIOException(sQLException);
        }
    }

    public void flush() throws IOException {
        if (this.needFlush) {
            this.storePage();
            this.needFlush = false;
        }
    }

    public void close() {
        this.store = null;
    }

    int getCurrentDataPageId() {
        return this.data.getPos();
    }

    void fillPage() throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("pageOut.storePage fill " + this.data.getPos());
        }
        this.reserve(this.data.getRemaining() + 1);
        this.reserved -= this.data.getRemaining();
        this.data.write(null);
        this.initNextData();
    }

    long getSize() {
        return this.pages * this.store.getPageSize();
    }

    void free(PageStreamTrunk pageStreamTrunk) throws SQLException {
        this.pages -= pageStreamTrunk.free();
    }
}

