/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.IOUtils;
import org.h2.util.New;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private static long lastGC;
    private static final boolean ALLOW_ALL_CLASSES;
    private static final HashSet<String> ALLOWED_CLASS_NAMES;
    private static final String[] ALLOWED_CLASS_NAME_PREFIXES;
    private static final HashMap<String, byte[]> RESOURCES;

    private Utils() {
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n++] << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
    }

    public static long readLong(byte[] byArray, int n) {
        return ((long)Utils.readInt(byArray, n) << 32) + ((long)Utils.readInt(byArray, n + 4) & 0xFFFFFFFFL);
    }

    public static void writeLong(byte[] byArray, int n, long l) {
        for (int i = 0; i < 8; ++i) {
            byArray[n + i] = (byte)(l >> 8 * (8 - i) & 0xFFL);
        }
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length == 0) {
            return n;
        }
        if (n > byArray.length) {
            return -1;
        }
        int n2 = byArray.length - byArray2.length + 1;
        while (n < n2) {
            block5: {
                for (int i = 0; i < byArray2.length; ++i) {
                    if (byArray[n + i] == byArray2[i]) {
                        continue;
                    }
                    break block5;
                }
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static byte[] convertStringToBytes(String string) {
        int n = string.length();
        if (n % 2 != 0) {
            throw DbException.get(90003, string);
        }
        byte[] byArray = new byte[n /= 2];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(Utils.getHexDigit(string, i + i) << 4 | Utils.getHexDigit(string, i + i + 1));
        }
        return byArray;
    }

    private static int getHexDigit(String string, int n) {
        char c = string.charAt(n);
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw DbException.get(90004, string);
    }

    public static int getByteArrayHash(byte[] byArray) {
        int n;
        int n2 = n = byArray.length;
        if (n < 50) {
            for (int i = 0; i < n; ++i) {
                n2 = 31 * n2 + byArray[i];
            }
        } else {
            int n3;
            int n4 = n / 16;
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = 31 * n2 + byArray[n3];
                n2 = 31 * n2 + byArray[--n];
            }
            for (n3 = 4 + n4; n3 < n; n3 += n4) {
                n2 = 31 * n2 + byArray[n3];
            }
        }
        return n2;
    }

    public static String convertBytesToString(byte[] byArray) {
        return Utils.convertBytesToString(byArray, byArray.length);
    }

    public static String convertBytesToString(byte[] byArray, int n) {
        char[] cArray = new char[n + n];
        char[] cArray2 = HEX;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            cArray[i + i] = cArray2[n2 >> 4];
            cArray[i + i + 1] = cArray2[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static boolean compareSecure(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        if (byArray.length == 0) {
            return true;
        }
        int n = 0;
        for (int i = 0; i < byArray2.length; ++i) {
            n |= byArray[i] ^ byArray2[i];
        }
        return n == 0;
    }

    public static int compareNotNull(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            if (by == by2) continue;
            return by > by2 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static byte[] copy(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n > byArray2.length) {
            byArray2 = new byte[n];
        }
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static byte[] cloneByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public static byte[] serialize(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw DbException.get(90026, throwable, throwable.toString());
        }
    }

    public static Object deserialize(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (Throwable throwable) {
            throw DbException.get(90027, throwable, throwable.toString());
        }
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int getMemoryUsed() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static int getMemoryFree() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        return (int)(l >> 10);
    }

    public static long getMemoryMax() {
        long l = Runtime.getRuntime().maxMemory();
        return l / 1024L;
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = System.currentTimeMillis();
        if (lastGC + 50L < l2) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long l3 = runtime.totalMemory();
                if (l3 == l) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l = l3;
            }
        }
    }

    public static byte[] newBytes(int n) {
        try {
            if (n == 0) {
                return EMPTY_BYTES;
            }
            return new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("Requested memory: " + n);
            outOfMemoryError2.initCause(outOfMemoryError);
            throw outOfMemoryError2;
        }
    }

    public static int[] newIntArray(int n) {
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[n];
    }

    public static long[] newLongArray(int n) {
        if (n == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[n];
    }

    public static Class<?> loadUserClass(String string) {
        if (!ALLOW_ALL_CLASSES && !ALLOWED_CLASS_NAMES.contains(string)) {
            boolean bl = false;
            for (String string2 : ALLOWED_CLASS_NAME_PREFIXES) {
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                throw DbException.get(90134, string);
            }
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                throw DbException.get(90086, classNotFoundException, string);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90086, noClassDefFoundError, string);
        }
        catch (Error error) {
            throw DbException.get(50000, error, string);
        }
    }

    public static byte[] getResource(String string) throws IOException {
        InputStream inputStream;
        Object object = RESOURCES.size() == 0 ? (Object)((inputStream = Utils.class.getResourceAsStream(string)) == null ? null : IOUtils.readBytesAndClose(inputStream, 0)) : RESOURCES.get(string);
        return object == null ? EMPTY_BYTES : object;
    }

    private static void loadResourcesFromZip() {
        InputStream inputStream = Utils.class.getResourceAsStream("data.zip");
        if (inputStream == null) {
            return;
        }
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                IOUtils.copy(zipInputStream, byteArrayOutputStream);
                zipInputStream.closeEntry();
                RESOURCES.put(string, byteArrayOutputStream.toByteArray());
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Object callStaticMethod(String string, Object ... objectArray) throws Exception {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Utils.classMethodInternal(string3, Class.forName(string2), null, objectArray);
    }

    public static Object callMethod(Object object, String string, Object ... objectArray) throws Exception {
        return Utils.classMethodInternal(string, object.getClass(), object, objectArray);
    }

    private static Object classMethodInternal(String string, Class<?> clazz, Object object, Object ... objectArray) throws Exception {
        Method method = null;
        int n = 0;
        boolean bl = object == null;
        for (Method method2 : clazz.getMethods()) {
            int n2;
            if (Modifier.isStatic(method2.getModifiers()) != bl || !method2.getName().equals(string) || (n2 = Utils.match(method2.getParameterTypes(), objectArray)) <= n) continue;
            n = n2;
            method = method2;
        }
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method.invoke(object, objectArray);
    }

    public static Object newInstance(String string, Object ... objectArray) throws Exception {
        Constructor<?> constructor = null;
        int n = 0;
        for (Constructor<?> constructor2 : Class.forName(string).getConstructors()) {
            int n2 = Utils.match(constructor2.getParameterTypes(), objectArray);
            if (n2 <= n) continue;
            n = n2;
            constructor = constructor2;
        }
        if (constructor == null) {
            throw new NoSuchMethodException(string);
        }
        return constructor.newInstance(objectArray);
    }

    private static int match(Class<?>[] classArray, Object[] objectArray) {
        if (classArray.length == objectArray.length) {
            int n = 1;
            for (int i = 0; i < classArray.length; ++i) {
                Class<?> clazz;
                Class<?> clazz2 = Utils.getNonPrimitiveClass(classArray[i]);
                if (clazz2 == (clazz = objectArray[i].getClass())) {
                    ++n;
                    continue;
                }
                if (clazz2.isAssignableFrom(clazz)) continue;
                return 0;
            }
            return n;
        }
        return 0;
    }

    public static Object getStaticField(String string) throws Exception {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return Class.forName(string2).getField(string3).get(null);
    }

    public static Object getField(Object object, String string) throws Exception {
        return object.getClass().getField(string).get(object);
    }

    public static boolean isClassPresent(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    static {
        ALLOWED_CLASS_NAMES = New.hashSet();
        RESOURCES = New.hashMap();
        String string = SysProperties.ALLOWED_CLASSES;
        ArrayList<String> arrayList = New.arrayList();
        boolean bl = false;
        for (String string2 : StringUtils.arraySplit(string, ',', true)) {
            if (string2.equals("*")) {
                bl = true;
                continue;
            }
            if (string2.endsWith("*")) {
                arrayList.add(string2.substring(0, string2.length() - 1));
                continue;
            }
            ALLOWED_CLASS_NAMES.add(string2);
        }
        ALLOW_ALL_CLASSES = bl;
        ALLOWED_CLASS_NAME_PREFIXES = new String[arrayList.size()];
        arrayList.toArray(ALLOWED_CLASS_NAME_PREFIXES);
        Utils.loadResourcesFromZip();
    }
}

